% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_lasso.R
\name{shiny_lasso_test_reactval}
\alias{shiny_lasso_test_reactval}
\title{Shiny Lasso Test w/ Reactive Values}
\usage{
shiny_lasso_test_reactval(tomic, tomic_table)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{tomic_table}{A table taken from a tidy (i.e., augmented measurements)
or triple omic dataset}
}
\value{
A \code{shiny} app
}
\description{
Tests the shiny lasso module as a stand-alone application when the
  \code{tomic} is a \code{reativeVal}.
}
\examples{
if (interactive()) {
  tomic <- brauer_2008_triple
  tomic_table <- tomic[["samples"]] \%>\% dplyr::filter(nutrient == "G")
  shiny_lasso_test_reactval(tomic, tomic_table)

  tomic_table <- tomic[["measurements"]] \%>\% dplyr::filter(expression < -3)
  shiny_lasso_test_reactval(tomic, tomic_table)
}
}
