% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_forecast.R
\name{get_forecast}
\alias{get_forecast}
\title{Download point-level ensemble weather forecasting using open-meteo API}
\usage{
get_forecast(
  latitude,
  longitude,
  site_id = NULL,
  forecast_days,
  past_days,
  model = "generic",
  variables = c("temperature_2m")
)
}
\arguments{
\item{latitude}{latitude degree north}

\item{longitude}{longitude degree east}

\item{site_id}{name of site location (optional, default = NULL)}

\item{forecast_days}{Number of days in the future for forecast (starts at current day)}

\item{past_days}{Number of days in the past to include in the data}

\item{model}{id of forest model https://open-meteo.com/en/docs/climate-api. Default = "generic"}

\item{variables}{vector of name of variable(s) https://open-meteo.com/en/docs/ensemble-api.}
}
\value{
data frame (in long format)
}
\description{
Download point-level ensemble weather forecasting using open-meteo API
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_forecast(latitude = 37.30,
            longitude = -79.83,
            forecast_days = 7,
            past_days = 2,
           model = "generic",
            variables = c("temperature_2m"))
\dontshow{\}) # examplesIf}
}
