% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%regex=\%}
\alias{\%regex=\%}
\title{Modify existing object by regular expression}
\usage{
x \%regex=\% value
}
\arguments{
\item{x}{a character vector}

\item{value}{c(pattern, replacement)}
}
\description{
This takes two arguments just like \code{gsub} - a patterns and a replacement.
It will only overwrite the parts of any character where the pattern is matched with the second argument.
If you want to overwrite whole elements via a regex (i.e. replace the entire element if it matches),
use \code{\%regex<-\%} instead.
}
\examples{
# Apply a regular expression/substitution to x:

 x <- c("a1b", "b1", "c", "d0")

 # change any number to "x"

  x \\\%regex=\\\% c("\\\\d+", "x")

 print(x)

 # "axb" "b" "c" "dx"
}
