% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{string_arithmetic}
\alias{string_arithmetic}
\alias{\%+\%}
\alias{\%-\%}
\alias{\%s*\%}
\alias{\%s/\%}
\title{String operators}
\usage{
x \%+\% y

x \%-\% y

x \%s*\% y

x \%s/\% y
}
\arguments{
\item{x}{a string}

\item{y}{a string}
}
\description{
Perform string concatenation and arithmetic is a similar way to other languages.
String division is not present in languages like Python, although arguably it is
more useful than string multiplication and can be used with regulr expressions.
}
\examples{
("ab" \%+\% "c") == "abc" # TRUE
("abc" \%-\% "b") == "ac" # TRUE
("ac" \%s*\% 2) == "acac" # TRUE
("acac" \%s/\% "c") == 2  # TRUE
# String division with a regular expression:
'an apple a day keeps the malignant spirit of Steve Jobs at bay' \%s/\% 'Steve Jobs|apple'

}
\author{
Ben Wiseman, \email{benjamin.wiseman@kornferry.com}
}
