% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{example3_flb_25_dims_box_con}
\alias{example3_flb_25_dims_box_con}
\title{Example 3: Minimize a function using L-BFGS-B with 25-dimensional box constrained}
\usage{
example3_flb_25_dims_box_con()
}
\description{
Minimize a function using L-BFGS-B with 25-dimensional box constrained.
}
\examples{
flb <- function(x)
{ p <- length(x); sum(c(1, rep(4, p-1)) * (x - c(1, x[-p])^2)^2) }
## 25-dimensional box constrained
optim(rep(3, 25), flb, NULL, method = "L-BFGS-B",
     lower = rep(2, 25), upper = rep(4, 25)) # par[24] is *not* at boundary

## corresponding C++ implementation:
example3_flb_25_dims_box_con()
}
