% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcid_id.r
\name{orcid_id}
\alias{orcid_id}
\title{Get data for particular ORCID's}
\usage{
orcid_id(orcid, ...)
}
\arguments{
\item{orcid}{(character) A single Orcid identifier, of the
form XXXX-XXXX-XXXX-XXXX}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
A named list of results - from a call to \code{\link[=orcid_person]{orcid_person()}}
}
\description{
Get data for particular ORCID's
}
\examples{
\dontrun{
res <- orcid_id(orcid = "0000-0002-9341-7985")
res$`0000-0002-9341-7985`
res$`0000-0002-9341-7985`$`name`
res$`0000-0002-9341-7985`$`other-names`
res$`0000-0002-9341-7985`$`biography`
res$`0000-0002-9341-7985`$`researcher-urls`
res$`0000-0002-9341-7985`$`emails`
res$`0000-0002-9341-7985`$`addresses`
res$`0000-0002-9341-7985`$`keywords`
res$`0000-0002-9341-7985`$`external-identifiers`
res$`0000-0002-9341-7985`$`emails`

ids <- c("0000-0003-1620-1408", "0000-0002-9341-7985")
res <- lapply(ids, orcid_id)
vapply(res, function(x) x[[1]]$name$`family-name`$value, "")
}
}
