% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcid_person.R
\name{orcid_person}
\alias{orcid_person}
\title{Get personal data for a person}
\usage{
orcid_person(orcid, details = FALSE, ...)
}
\arguments{
\item{orcid}{(character) Orcid identifier(s), of the form
XXXX-XXXX-XXXX-XXXX. required.}

\item{details}{(logical). also get details. Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
A list of results for each Orcid ID passed in, with each element
named by the Orcid ID
}
\description{
Get personal data for a person
}
\details{
This function is vectorized, so you can pass in many ORCID's, and
there's an element returned for each ORCID you put in.
}
\examples{
\dontrun{
res <- orcid_person(orcid = "0000-0002-9341-7985")
res$`0000-0002-9341-7985`
names(res$`0000-0002-9341-7985`)
res$`0000-0002-9341-7985`$`last-modified`
res$`0000-0002-9341-7985`$`keywords`
res$`0000-0002-9341-7985`$`biography`
}
}
