% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatPvalue.R
\name{formatPvalue}
\alias{formatPvalue}
\title{Pretty formatting of \emph{p} values}
\usage{
formatPvalue(values, digits = 3, spaces = TRUE, includeP = TRUE)
}
\arguments{
\item{values}{The p-values to format.}

\item{digits}{The number of digits to round to. Numbers smaller
than this number will be shown as <.001 or <.0001 etc.}

\item{spaces}{Whether to include spaces between symbols,
operators, and digits.}

\item{includeP}{Whether to include the 'p' and '='-symbol in the
results (the '<' symbol is always included).}
}
\value{
A formatted P value, roughly according to APA style
guidelines. This means that the \link{noZero} function is used to
remove the zero preceding the decimal point, and p values
that would round to zero given the requested number of digits
are shown as e.g. p<.001.
}
\description{
Pretty formatting of \emph{p} values
}
\examples{
formatPvalue(cor.test(mtcars$mpg,
                      mtcars$disp)$p.value);
formatPvalue(cor.test(mtcars$drat,
                      mtcars$qsec)$p.value);
}
\seealso{
\code{\link[=formatCI]{formatCI()}}, \code{\link[=formatR]{formatR()}}, \code{\link[=noZero]{noZero()}}
}
