% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\docType{data}
\name{opts}
\alias{opts}
\alias{set}
\alias{get}
\alias{reset}
\title{Options for the rosetta package}
\format{
An object of class \code{list} of length 4.
}
\usage{
opts
}
\description{
The \code{rosetta::opts} object contains three functions to set, get, and reset
options used by the rosetta package. Use \code{rosetta::opts$set} to set options,
\code{rosetta::opts$get} to get options, or \code{rosetta::opts$reset} to reset specific or
all options to their default values.
}
\details{
It is normally not necessary to get or set \code{rosetta} options.

The following arguments can be passed:

\describe{
\item{...}{For \code{rosetta::opts$set}, the dots can be used to specify the options
to set, in the format \code{option = value}, for example,
\code{varViewCols = c("values", "level")}. For
\code{rosetta::opts$reset}, a list of options to be reset can be passed.}
\item{option}{For \code{rosetta::opts$set}, the name of the option to set.}
\item{default}{For \code{rosetta::opts$get}, the default value to return if the
option has not been manually specified.}
}

The following options can be set:

\describe{

\item{varViewCols}{The order and names of the columns to include in the
variable view.}

\item{showLabellerWarning}{Whether to show a warning if labeller labels
are encountered.}

}
}
\examples{
### Get the default columns in the variable view
rosetta::opts$get(varViewCols);

### Set it to a custom version
rosetta::opts$set(varViewCols = c("values", "level"));

### Check that it worked
rosetta::opts$get(varViewCols);

### Reset this option to its default value
rosetta::opts$reset(varViewCols);

### Check that the reset worked, too
rosetta::opts$get(varViewCols);

}
\keyword{datasets}
