% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RosvQuery1.R
\name{RosvQuery1}
\alias{RosvQuery1}
\title{R6 Class for OSV Query Endpoint}
\value{
An R6 object to operate with OSV query endpoint.
}
\description{
An R6 class to provide a lower-level interface to the query endpoint of the OSV API.
}
\details{
Pageination is implemented via \code{httr2::req_perform_iterative()} and a private method for
extracting tokens automatically. When initialized, the page_token is set to \code{NULL};
if a token is generated for large results the process is handled internally. The response object
will contain a list of all returned responses before any formatting occurred. The content field will
contain the list of vulnerabilities which may be further parsed into a table format.
}
\examples{
query <- RosvQuery1$new(commit = '6879efc2c1596d11a6a6ad296f80063b558d5e0f')
query
}
\seealso{
\url{https://google.github.io/osv.dev/post-v1-query/}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{request}}{Request object made by \code{httr2}.}

\item{\code{content}}{Body contents of response from OSV API.}

\item{\code{response}}{Response object returned from OSV API.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RosvQuery1-new}{\code{RosvQuery1$new()}}
\item \href{#method-RosvQuery1-run}{\code{RosvQuery1$run()}}
\item \href{#method-RosvQuery1-parse}{\code{RosvQuery1$parse()}}
\item \href{#method-RosvQuery1-print}{\code{RosvQuery1$print()}}
\item \href{#method-RosvQuery1-clone}{\code{RosvQuery1$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvQuery1-new"></a>}}
\if{latex}{\out{\hypertarget{method-RosvQuery1-new}{}}}
\subsection{Method \code{new()}}{
Set the core request details for subsequent use when called in \code{run()} method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvQuery1$new(
  commit = NULL,
  version = NULL,
  name = NULL,
  ecosystem = NULL,
  purl = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{commit}}{Commit hash to query against (do not use when version set).}

\item{\code{version}}{Version of package.}

\item{\code{name}}{Name of package.}

\item{\code{ecosystem}}{Ecosystem package lives within (must be set if using \code{name}).}

\item{\code{purl}}{URL for package (do not use if \code{name} or \code{ecosystem} is set).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvQuery1-run"></a>}}
\if{latex}{\out{\hypertarget{method-RosvQuery1-run}{}}}
\subsection{Method \code{run()}}{
Perform the request and return response for OSV API call.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvQuery1$run()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvQuery1-parse"></a>}}
\if{latex}{\out{\hypertarget{method-RosvQuery1-parse}{}}}
\subsection{Method \code{parse()}}{
Parse the contents returned into a tidier format. Can
use \code{future} plans to help parallelize. Not all contents are parsed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvQuery1$parse()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvQuery1-print"></a>}}
\if{latex}{\out{\hypertarget{method-RosvQuery1-print}{}}}
\subsection{Method \code{print()}}{
Print basic details of query object to screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvQuery1$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Reserved for possible future use.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvQuery1-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RosvQuery1-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvQuery1$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
