% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tol.R
\name{tol_subtree}
\alias{tol_subtree}
\title{Extract a subtree from the synthetic tree}
\usage{
tol_subtree(ott_id = NULL, tree_id = NULL, file, ...)
}
\arguments{
\item{ott_id}{the ott id of the node in the tree that should serve
as the root of the tree returned.}

\item{tree_id}{the identifier for the synthesis tree. Currently a
single draft tree is supported, so this argument is
superfluous and may be safely ignored.}

\item{file}{if specified, the function will write the subtree to a
file in newick format.}

\item{...}{additional arguments to customize the API call (see
\code{\link{rotl}} for more information).}
}
\value{
If no value is specified to the \code{file} argument
    (default), a phyogenetic tree of class \code{phylo}.

    Otherwise, the function returns invisibly a logical indicating
    whether the file was successfully created.
}
\description{
Extract a subtree from the synthetic tree from an ott id.
}
\details{
Return a complete subtree of the draft tree descended
    from some specified node. The node to use as the start node
    may be specified using an ott id. If the specified node is not
    in the synthetic tree (or is entirely absent from the graph),
    an error will be returned.
}
\examples{
   \dontrun{
      res <- tol_subtree(ott_id=81461)
    }
}

