% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getNumberOfSubjects}
\alias{getNumberOfSubjects}
\title{Get Number Of Subjects}
\usage{
getNumberOfSubjects(time, ..., accrualTime = C_ACCRUAL_TIME_DEFAULT,
  accrualIntensity = C_ACCRUAL_INTENSITY_DEFAULT,
  maxNumberOfSubjects = NA_real_)
}
\arguments{
\item{time}{A numeric vector with time values.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{accrualTime}{The assumed accrual time intervals for the study, default is 
\code{c(0,12)} (see details).}

\item{accrualIntensity}{A vector of accrual intensities, default is the relative 
intensity \code{0.1} (see details).}

\item{maxNumberOfSubjects}{If \code{maxNumberOfSubjects > 0} is specified, 
the end of accrual at specified \code{accrualIntensity} for the specified number of subjects is determined or
   \code{accrualIntensity} is calculated at fixed end of accrual.}
}
\value{
Returns a \code{\link{NumberOfSubjects}} object.
}
\description{
Returns the number of recruited subjects at given time vector.
}
\details{
For details of the parameters \code{accrualTime} and \code{accrualIntensity} 
see \code{\link{getSampleSizeSurvival}}.
}
\keyword{internal}
