% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_design.R
\name{plot.TrialDesign}
\alias{plot.TrialDesign}
\title{Trial Design Plotting}
\usage{
\method{plot}{TrialDesign}(x, y, main = NA_character_,
  xlab = NA_character_, ylab = NA_character_, type = 1,
  palette = "Set1", theta = seq(-1, 1, 0.01), nMax = NA_integer_,
  plotPointsEnabled = NA, legendPosition = NA_integer_,
  showSource = FALSE, ...)
}
\arguments{
\item{x}{The trial design, obtained from \cr
\code{\link{getDesignGroupSequential}}, \cr
\code{\link{getDesignInverseNormal}} or \cr
\code{\link{getDesignFisher}}.}

\item{y}{Not available for this kind of plot (is only defined to be compatible to the generic plot function).}

\item{main}{The main title.}

\item{xlab}{The x-axis label.}

\item{ylab}{The y-axis label.}

\item{type}{The plot type (default = \code{1}). The following plot types are available:
\itemize{
  \item \code{1}: creates a 'Boundaries' plot
  \item \code{3}: creates a 'Stage Levels' plot
  \item \code{4}: creates a 'Type One Error Spending' plot
  \item \code{5}: creates a 'Power and Early Stopping' plot
  \item \code{6}: creates an 'Average Sample Size and Power / Early Stop' plot
  \item \code{7}: creates an 'Power' plot
  \item \code{8}: creates an 'Early Stopping' plot
  \item \code{9}: creates an 'Average Sample Size' plot
}}

\item{palette}{The palette, default is \code{"Set1"}.}

\item{theta}{A vector of theta values.}

\item{nMax}{The maximum sample size.}

\item{plotPointsEnabled}{If \code{TRUE}, additional points will be plotted.}

\item{legendPosition}{The position of the legend. 
By default (\code{NA_integer_}) the algorithm tries to find a suitable position. 
Choose one of the following values to specify the position manually:
\itemize{
  \item \code{-1}: no legend will be shown
  \item \code{NA}: the algorithm tries to find a suitable position
  \item \code{0}: legend position outside plot
  \item \code{1}: legend position left top
  \item \code{2}: legend position left center
  \item \code{3}: legend position left bottom
  \item \code{4}: legend position right top
  \item \code{5}: legend position right center
  \item \code{6}: legend position right bottom
}}

\item{showSource}{If \code{TRUE}, the parameter names of the object will 
be printed which were used to create the plot; that may be, e.g., 
useful to check the values or to create own plots with \code{\link[graphics]{plot}}.}

\item{...}{Optional \code{ggplot2} arguments.}
}
\description{
Plots a trial design.
}
\details{
Generic function to plot a trial design.



Generic function to plot a trial design.
}
\examples{

design <- getDesignInverseNormal(kMax = 3, alpha = 0.025, 
    typeOfDesign = "asKD", gammaA = 2, 
    informationRates = c(0.2, 0.7, 1), 
    typeBetaSpending = "bsOF")

if (require(ggplot2)) {
    plot(design) # default: type = 1
}

}
\seealso{
\code{\link{plot.TrialDesignSet}} to compare different designs or design parameters visual.
}
