% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{generator}
\alias{generator}
\title{Generate a time series containing a Visual Charting Pattern.}
\usage{
generator(start = 0, dlength = 100, tot.spread = 100, presig = 0,
  postsig = 0, plength = 0, parts = c(15, 25, 50, 75, 85), sprd = c(50,
  25, 100, 25, 50))
}
\arguments{
\item{start}{Starting value}

\item{dlength}{Integer. Length of the signal part of the time series}

\item{tot.spread}{Integer. Difference between the lowest and highest value of the time series}

\item{presig}{Integer. Length of the pre-signal part of the time series}

\item{postsig}{Integer. Length of the post-signal part of the time series}

\item{plength}{No longer needed, kept for compatability. Set to 0.}

\item{parts}{Vector of Integers. Must be the same length as \code{sprd}
Defines how far the extrema lie apart from another (in percent)
PREVIOUSLY: Vector must contain plength + 2 elements, the first element being 0 and the last 100.}

\item{sprd}{Vector of Integers. Must be the same length as \code{parts}
Defines the value of the extrema in percent of \code{tot.spread} in relation to \code{start}.
PREVIOUSLY: Vector must contain plength + 2 elements, the first and last elemnt should be 0.}
}
\value{
Time series with (optional) pre- or post signal, and the specified pattern.
}
\description{
Generate a time series containing a Visual Charting Pattern.
}
\examples{
\dontrun{
#create a standard HS pattern:
generator()
#

#create a shifted head and shoulders pattern
generator(sprd = c(20,10,90,40,60))
#
#create a Double Tops pattern
generator(plength=3,parts=c(25,50,75),sprd=c(80,40,80))
#
#create a Rectangle Tops pattern
generator(plength=5,parts=c(20,40,50,60,80),sprd=c(80,40,80,40,80))
#
#create a single peak, 10 data points, max is approximately 10
generator(0,10,10,0,0,0,50,100)
}

}
