% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.pcss.core.R
\name{biplot.pcss.core}
\alias{biplot.pcss.core}
\title{Generate Biplots from \code{pcss.core} Output}
\usage{
\method{biplot}{pcss.core}(
  x,
  ndim = 3,
  highlight.core = c("size", "variance", "logistic", "none"),
  show.traits = c("all", "none", "quantitative", "qualitative"),
  qual.scale = 1,
  quant.scale = 1,
  point.alpha = 0.8,
  segment.alpha = 0.8,
  ...
)
}
\arguments{
\item{x}{An object of class \code{pcss.core}.}

\item{ndim}{The number of dimensions for which biplots have to plotted.}

\item{highlight.core}{The core collection to be highlighted. Either
\code{"size"}, \code{"variance"}, \code{"logistic"}, or \code{"none"}. See
\strong{Details}.}

\item{show.traits}{Which kind of the traits to be shown in the biplot. Either
\code{"all"}, \code{"none"}, \code{"quantitative"} or \code{"qualitative"}.}

\item{qual.scale}{A scale factor to be applied to qualitative trait
coordinates plotted in biplot.}

\item{quant.scale}{A scale factor to be applied to quantitative trait
coordinates plotted in biplot.}

\item{point.alpha}{Alpha transparency value for biplot points.}

\item{segment.alpha}{Alpha transparency value for biplot segments.}

\item{...}{Unused.}
}
\value{
A list of biplots as \code{ggplot} objects.
}
\description{
\code{biplot.pcss.core} generates biplots of scores of genotypes with or
without vectors for traits from the output of \code{pcss.core}.
}
\details{
Use \code{"size"} to highlight core collection according to the threshold
\code{size} criterion or use \code{"variance"} to highlight core collection
according to the variability threshold criterion or use  \code{"logistic"} to
highlight core collection generated according to inflection point of rate of
progress of cumulative variability retained identified by logistic
regression. Use \code{"none"} to not highlight any accessions.
}
\examples{

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Prepare example data
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

suppressPackageStartupMessages(library(EvaluateCore))

# Get data from EvaluateCore

data("cassava_EC", package = "EvaluateCore")
data = cbind(Genotypes = rownames(cassava_EC), cassava_EC)
quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")
rownames(data) <- NULL

# Convert qualitative data columns to factor
data[, qual] <- lapply(data[, qual], as.factor)


library(FactoMineR)
suppressPackageStartupMessages(library(factoextra))

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# With quantitative data
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

out1 <- pcss.core(data = data, names = "Genotypes",
                  quantitative = quant,
                  qualitative = NULL, eigen.threshold = NULL, size = 0.2,
                  var.threshold = 0.75)

\donttest{
# Plot biplot
biplot(out1, ndim = 3, highlight.core = "size", quant.scale = 3,
       point.alpha = 0.5)

# Plot biplot with FactoMineR
plot(out1$raw.out, choix=c("ind"), label  = "none", axes = c(1, 2))

plot(out1$raw.out, choix=c("ind"), label  = "none", axes = c(1, 3))

plot(out1$raw.out, choix=c("ind"), label  = "none", axes = c(2, 3))

# Plot biplot with factoextra
fviz_pca_biplot(out1$raw.out, geom.ind = "point", axes = c(1, 2))

fviz_pca_biplot(out1$raw.out, geom.ind = "point", axes = c(1, 3))

fviz_pca_biplot(out1$raw.out, geom.ind = "point", axes = c(2, 3))
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Get core sets with PCSS (qualitative data)
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

out2 <- pcss.core(data = data, names = "Genotypes", quantitative = NULL,
                  qualitative = qual, eigen.threshold = NULL,
                  size = 0.2, var.threshold = 0.75)

\donttest{
# Plot biplot
biplot(out2, ndim = 3, highlight.core = "size", qual.scale = 1,
       point.alpha = 0.5)

# Plot biplot with FactoMineR
plot(out2$raw.out, choix=c("ind"), label  = "none", axes = c(1, 2))

plot(out2$raw.out, choix=c("ind"), label  = "none", axes = c(1, 3))

plot(out2$raw.out, choix=c("ind"), label  = "none", axes = c(2, 3))

# Plot biplot with factoextra
fviz_mca_biplot(out2$raw.out, geom.ind = "point", axes = c(1, 2))

fviz_mca_biplot(out2$raw.out, geom.ind = "point", axes = c(1, 3))

fviz_mca_biplot(out2$raw.out, geom.ind = "point", axes = c(2, 3))
}

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Get core sets with PCSS (quantitative and qualitative data)
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

out3 <- pcss.core(data = data, names = "Genotypes",
                  quantitative = quant,
                  qualitative = qual, eigen.threshold = NULL)

\donttest{
# Plot biplot
biplot(out3, ndim = 3, highlight.core = "size",
       quant.scale = 3, qual.scale = 1,
       point.alpha = 0.5)

# Plot biplot with FactoMineR
plot(out3$raw.out, choix=c("ind"), label  = "none", axes = c(1, 2))

plot(out3$raw.out, choix=c("ind"), label  = "none", axes = c(1, 3))

plot(out3$raw.out, choix=c("ind"), label  = "none", axes = c(2, 3))

# Plot biplot with factoextra

# Fix rownames
row.names(out3$raw.out$quali.var$coord) <-
  unlist(lapply(seq_along(data[, qual]),
                function(i) paste(qual[i],
                                  levels(data[, qual[i]]), sep = "_")))

fviz_famd_ind(out3$raw.out, geom = "point", axes = c(1, 2))

fviz_famd_ind(out3$raw.out, geom = "point", axes = c(1, 3))

fviz_famd_ind(out3$raw.out, geom = "point", axes = c(2, 3))
}

}
\seealso{
\code{\link[rpcss]{pcss.core}}, \code{\link[FactoMineR]{plot.PCA}},
  \code{\link[FactoMineR]{plot.MCA}}, \code{\link[FactoMineR]{plot.FAMD}},
  \code{\link[factoextra]{fviz_pca}}, \code{\link[factoextra]{fviz_mca}},
  \code{\link[factoextra]{fviz_famd}}
}
