% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.pcss.core.R
\name{subset.pcss.core}
\alias{subset.pcss.core}
\title{Fetch the names of individuals/genotypes in the core set generated from
\code{pcss.core} Output}
\usage{
\method{subset}{pcss.core}(x, criterion = c("size", "variance", "logistic"), ...)
}
\arguments{
\item{x}{An object of class \code{pcss.core}.}

\item{criterion}{The core collection generation criterion. Either
\code{"size"}, \code{"variance"}, or \code{"logistic"}. See
\strong{Details}.}

\item{...}{Unused.}
}
\value{
The names of individuals/genotypes in the core collection as a
  character vector.
}
\description{
\code{subset.pcss.core} returns names of individuals/genotypes in the core
collection from \code{pcss.core} Output.
}
\details{
Use \code{"size"} to return names of individuals/genotypes in the core
collection according to the threshold \code{size} criterion or use
\code{"variance"} to return names according to the variability threshold
criterion or use  \code{"logistic"} to return names according to inflection
point of rate of progress of cumulative variability retained identified by
logistic regression.
}
\examples{

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Prepare example data
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

suppressPackageStartupMessages(library(EvaluateCore))

# Get data from EvaluateCore

data("cassava_EC", package = "EvaluateCore")
data = cbind(Genotypes = rownames(cassava_EC), cassava_EC)
quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")
rownames(data) <- NULL

# Convert qualitative data columns to factor
data[, qual] <- lapply(data[, qual], as.factor)

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# With quantitative data
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

out1 <- pcss.core(data = data, names = "Genotypes",
                  quantitative = quant,
                  qualitative = NULL, eigen.threshold = NULL, size = 0.2,
                  var.threshold = 0.75)

# Core sets
out1$cores.info

# Fetch genotype names of core set by size criterion
subset(x = out1, criterion = "size")

# Fetch genotype names of core set by variance criterion
subset(x = out1, criterion = "variance")

# Fetch genotype names of core set by logistic regression criterion
subset(x = out1, criterion = "logistic")

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Get core sets with PCSS (qualitative data)
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

out2 <- pcss.core(data = data, names = "Genotypes", quantitative = NULL,
                  qualitative = qual, eigen.threshold = NULL,
                  size = 0.2, var.threshold = 0.75)

# Core sets
out2$cores.info

# Fetch genotype names of core set by size criterion
subset(x = out2, criterion = "size")

# Fetch genotype names of core set by variance criterion
subset(x = out2, criterion = "variance")

# Fetch genotype names of core set by logistic regression criterion
subset(x = out2, criterion = "logistic")
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Get core sets with PCSS (quantitative and qualitative data)
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

out3 <- pcss.core(data = data, names = "Genotypes",
                  quantitative = quant,
                  qualitative = qual, eigen.threshold = NULL)

# Core sets
out3$cores.info

# Fetch genotype names of core set by size criterion
subset(x = out3, criterion = "size")

# Fetch genotype names of core set by variance criterion
subset(x = out3, criterion = "variance")

# Fetch genotype names of core set by logistic regression criterion
subset(x = out3, criterion = "logistic")

}
\seealso{
\code{\link[rpcss]{pcss.core}}
}
