% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R, R/rpg.R
\name{disconnect}
\alias{connect}
\alias{disconnect}
\title{PostgreSQL connection}
\usage{
disconnect()

connect(dbname, ...)
}
\arguments{
\item{dbname}{name of the database or a valid \code{libpq} connection string}

\item{...}{named optional connection parameters}
}
\value{
\code{connect} returns one of:
\tabular{ll}{
\code{CONNECTION_OK} \tab Succesful connection \cr
\code{CONNECTION_BAD} \tab Connection failed \cr}
}
\description{
Manage database connection
}
\details{
\code{disconnect} will free any query results as well
as clean up the connection data. It is called in the pakcage
\code{\link{.Last.lib}} function when exiting \code{R}.

If no connection parameters are supplied, the
connection will fallback to default parameters. Usually
this establishes a connection on the localhost to a database,
if it exists, with the same name as the user.

Valid keywords and their defaults can be obtained by calling
\code{get_conn_defaults(all = TRUE)}. A valid \code{libpq}
connection string is composed of \code{keyword = value} pairs
separated by whitespace. You can either pass the entire string
or use named arguments. The names of the arguments will be used
as keywords and their values as values.

If a password was required but not provided, \code{connect} will
will open a dialog and prompt for a password. The connection is
then re-tried and the status returned.
}
\note{
Do not open a connection and then fork the R
process. The behavior will be unpredictable. It is perfectly
acceptable however to call \code{connect} within each
forked instance.
}
\examples{
\dontrun{
fetch("SHOW search_path") # default connection
connect("test")
connect(dbname = "test")
connect(dbname = "test", host = "localhost")
connect("dbname = test host = localhost")
disconnect()}
}
\author{
Timothy H. Keitt
}

