\name{plot.gene}
\alias{plot.gene}
\title{Gene plot}
\usage{plot.gene(x, y=0, height=1, arrow.density=5, angle=30, col="black",
    lty=par("lty"), lwd=par("lwd"), add=FALSE, xlim=range.feat(x),
    ylim=c(y - height * 3/4, y + height * 3/4), ...)}
\description{make gene plot}
\keyword{features}
\keyword{plot}
\author{Melissa J. Hubisz}
\arguments{\item{x}{An object of type \code{feat}}
\item{y}{the location of the plot on the y axis}
\item{height}{the height of the boxes}
\item{arrow.density}{The density of the arrows in arrows per inch}
\item{angle}{angle (in degrees) of the arrow heads}
\item{col}{color to use for plotting}
\item{lty}{line type for arrows, borders, and shading}
\item{lwd}{line width for arrows, borders and shading}
\item{add}{if \code{TRUE}, add to existing plot}
\item{xlim}{A numerical vector of length 2 giving the range for the x-axis.}
\item{ylim}{A numerical vector of length 2 giving the range for the y-axis.}
\item{...}{graphical parameters to be passed to \code{plot}.}}
\examples{
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
featFile <- "sol1.gp"
unzip(exampleArchive, featFile)
f <- read.feat(featFile)
plot.gene(f)
plot.gene(f, xlim=c(0, 10000))  #zoom in
}
