\name{plot.feat}
\alias{plot.feat}
\title{Features plot}
\usage{
  \method{plot}{feat} (x, y = 0, height = 1,
    plottype = "r", arrow.density = 5, angle = 30,
    col = "black",
    fill.col = if (plottype == "r") col else NULL,
    lty = par("lty"), lwd = par("lwd"), add = FALSE,
    xlim = range.feat(x),
    ylim = c(y - height * 3/4, y + height * 3/4), ...)
}
\arguments{
  \item{x}{an object of type \code{feat}}

  \item{y}{the location of the plot on the y axis}

  \item{height}{the height of the boxes}

  \item{plottype}{either "r" for rectangles or "a" for
  arrows, "b" for arrows within rectangles, or "l" for line
  segments only.}

  \item{arrow.density}{If plottype=="a" or "b", then this
  gives the density of arrows in arrows per inch.
  Otherwise it gives the density of shading lines in the
  rectangles, and a value of \code{NULL} implies no shading
  lines.}

  \item{angle}{angle (in degrees) of the shading lines or
  arrows.}

  \item{col}{color to draw the boxes/lines/arrows with.}

  \item{fill.col}{Color to fill the rectangles with.  If
  \code{NULL} then do not fill.}

  \item{lty}{line type for lines, arrows, borders, and
  shading}

  \item{lwd}{line width for lines, arrows, borders and
  shading}

  \item{add}{if \code{TRUE}, add to existing plot}

  \item{xlim}{A numerical vector of length 2 giving the
  range for the x-axis.}

  \item{ylim}{A numerical vector of length 2 giving the
  range for the y-axis.}

  \item{...}{graphical parameters to be passed to
  \code{plot}.}
}
\description{
  plot features
}
\examples{
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
featFile <- "gencode.ENr334-100k.gff"
unzip(exampleArchive, featFile)
f <- read.feat(featFile)
# note that plot(f) does not work because features are stored as data.frames
plot.feat(f[f$feature=="CDS",])
unlink(featFile)
}
\author{
  Melissa J. Hubisz
}
\keyword{features}
\keyword{plot}

