\name{is.ordered.msa}
\alias{is.ordered.msa}
\title{MSA is Ordered?}
\usage{
  \method{is.ordered}{msa} (x)
}
\arguments{
  \item{x}{an MSA object}
}
\value{
  a boolean indicating whether the columns are in order
}
\description{
  Determines if an MSA object represents an ordered
  alignment.
}
\examples{
m <- msa(seqs=c("A--ACGTAT", "AG-AGGTAA", "AGGAGGTAG"),
         names=c("human", "mouse", "rat"))
is.ordered.msa(m)
m <- msa(seqs=c("A--ACGTAT", "AG-AGGTAA", "AGGAGGTAG"),
         names=c("human", "mouse", "rat"), is.ordered=FALSE)
is.ordered.msa(m)
}
\author{
  Melissa J. Hubisz and Adam Siepel
}
\keyword{msa}

