\name{plot.tm}
\alias{plot.tm}
\title{Make a bubble plot of the transition matrix for a tree model.}
\usage{
  \method{plot}{tm} (x, show.eq.freq = TRUE, max.cex = 10,
    eq.freq.max.cex = 5, alphabet = NULL, col = NULL,
    eq.freq.col = NULL, filled = TRUE, add = FALSE, ...)
}
\arguments{
  \item{x}{An object of type \code{tm}.}

  \item{show.eq.freq}{If \code{TRUE}, show bubbles
  representing equilibrium frequencies along the bottom of
  plot.}

  \item{max.cex}{A scaling factor which determines the size
  of the largest circle}

  \item{eq.freq.max.cex}{A scaling factor which determines
  the size of the largest circle in the equilibrium
  frequencies.}

  \item{alphabet}{A character vector representing the state
  names for each row/column of the matrix.  Can either be a
  vector of size \code{nrow(m)} or a single character
  string with \code{nrow(m)} characters.  Can also be
  \code{NULL} for no row/column labels.}

  \item{col}{If \code{NULL}, all circles will be drawn in
  black. Otherwise, col can be a matrix of the same
  dimension of \code{m}, each entry should indicate the
  color used for the corresponding cell in the transition
  matrix.}

  \item{eq.freq.col}{Should be vector of same length as
  eq.freq, though values will be recycled. Values in the
  vector indicate colors to draw the equilibrium frequency
  bubbles.}

  \item{filled}{If \code{TRUE}, plot filled circles.}

  \item{add}{If \code{TRUE}, add to the existing plot.
  Otherwise create a new plot.}

  \item{...}{Further arguments to be passed to
  \code{plot}.}
}
\description{
  Make a bubble plot of the transition matrix for a tree
  model.
}
\examples{
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
filename <- "rev.mod"
unzip(exampleArchive, filename)
tm <- read.tm(filename)
plot(tm)
plot(tm, show.eq.freq=FALSE)
plot(tm, max.cex=20, eq.freq.max.cex=1,
     col=matrix(1:16, nrow=4),
     eq.freq.col=c("red", "green"),
     filled=TRUE, add=TRUE)
plot.rate.matrix(tm[["rate.matrix"]],
                 eq.freq=tm[["backgd"]],
                 filled=FALSE)
plot.rate.matrix(tm[["rate.matrix"]],
                 eq.freq=tm[["backgd"]],
                 filled=TRUE, add=TRUE)
unlink(filename)
}
\author{
  Melissa J. Hubisz
}

