% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.R
\name{as.track.wig}
\alias{as.track.wig}
\title{Create a wig track}
\usage{
as.track.wig(wig = NULL, name, coord = NULL, score = NULL,
  short.label = NULL, col = "black", ylim = NULL, smooth = FALSE,
  numpoints = 250, horiz.line = NULL, horiz.lty = 2,
  horiz.col = "black")
}
\arguments{
\item{wig}{A "wig" object (Must have elements wig$coord and wig$score which should both
be numeric vectors).  coord/score may be passed directly instead.}

\item{name}{The name of the track (a character string)}

\item{coord}{(Alternative to wig) A numeric vector of coordinates (to be used for x-axis)}

\item{score}{(Alternative to wig) A numeric vector of scores (y-axis coords), should be
same length as coord.}

\item{short.label}{An optional character string to be displayed in left
hand margin of track}

\item{col}{The color to be used to plot this track.}

\item{ylim}{The limits to be used on the y-axis.  If NULL use entire range
of score.}

\item{smooth}{A logical value indicating whether to perform smoothing when plotting
this track}

\item{numpoints}{(Only used if \code{smooth==TRUE}).  An integer value indicating how many
points to display in the smoothed wig.}

\item{horiz.line}{If non-NULL, draw horizontal lines on the display at the given y coordinates}

\item{horiz.lty}{If horiz.line is defined, use this line type.}

\item{horiz.col}{If horiz.line is defined, use this color}
}
\value{
An object of type \code{track} which can be plotted with the plot.track
function
}
\description{
Create a wig track
}
\author{
Melissa J. Hubisz
}
\keyword{plot}

