% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_names.R
\name{get_names}
\alias{get_names}
\title{Get names for uuids.}
\usage{
get_names(
  uuid,
  supertaxa = NULL,
  subtaxa = NULL,
  options = NULL,
  stripauthority = TRUE,
  ...
)
}
\arguments{
\item{uuid}{UUID to get names for}

\item{supertaxa}{If immediate, returns data for immediate supertaxa ("parents").
If all, returns data for all supertaxa ("ancestors"). Otherwise, does not
include supertaxa.}

\item{subtaxa}{If immediate, returns data for immediate subtaxa ("children").
Otherwise, does not include subtaxa.}

\item{options}{See details for the options for options, get it, ha.}

\item{stripauthority}{If TRUE (default) the authority is stripped off of the
scientific name.}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Get names for uuids.
}
\details{
Here are the options for the options argument:
\itemize{
\item citationStart: (optional) Integer Indicates where in the string the
citation starts. May be null.
\item html: (optional) StringHTML version of the name.
\item namebankID: (optional) StringuBio Namebank identifier. May be null.
\item root: (optional) Boolean If true, this name has no hyperonyms (names of
supertaxa). (Should only be true for Panbiota/Vitae.)
\item string: (optional) String The text of the name, including the citation, if any.
\item type: (optional) String Either "scientific or "vernacular.
\item uid: (always) String Universally unique identifier.
\item uri: (optional) String The unique URI associated with the name.
\item votes: (optional) Integer The number of votes this name has received.
(Currently unused.)
}
}
\examples{
\dontrun{
get_names(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", options = "string")
get_names(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", supertaxa="immediate", 
   options=c("string namebankID"))
get_names(uuid = "f3254fbd-284f-46c1-ae0f-685549a6a373", supertaxa="all", 
   options="string")
}
}
