% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_attribution.R
\name{get_attribution}
\alias{get_attribution}
\title{Get PhyloPic attribution data}
\usage{
get_attribution(uuid = NULL)
}
\arguments{
\item{uuid}{\code{character}. A valid uuid for a PhyloPic silhouette such
as that returned by \code{\link[=get_uuid]{get_uuid()}} or \code{\link[=pick_phylopic]{pick_phylopic()}}.}
}
\value{
A \code{list} of PhyloPic attribution data for an image \code{uuid}.
}
\description{
This function provides a convenient way to obtain attribution data
for PhyloPic images via an image uuid returned by \code{\link[=get_uuid]{get_uuid()}}.
}
\details{
This function returns image \code{uuid} specific attribution data,
including: contributor name, contributor uuid, contributor contact,
image uuid and license.
}
\examples{
# Get valid uuid
uuid <- get_uuid(name = "Acropora cervicornis")
# Get attribution data for uuid
attri <- get_attribution(uuid = uuid)
}
