% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listspecies.R
\name{get_species_from_list}
\alias{get_species_from_list}
\title{Get existing list/lists of species}
\usage{
get_species_from_list(userid, access_token, list_id, verbose = FALSE,
  content = TRUE)
}
\arguments{
\item{userid}{A valid gmail address of the user}

\item{access_token}{Access token of the gmail address}

\item{list_id}{An integer id of the list to retrieve}

\item{verbose}{(optional)By default FALSE and shows minimal meta-data of the list.}

\item{content}{(optional)By default TRUE and shows the species collection of the list}
}
\value{
An existing list with metadata and content based on parameters
}
\description{
Get existing list/lists of species
}
\examples{
  # This gives you the syntax, but since the access token expires after one hour,
  # this particular example will not work.
  \dontrun{
  userid = "abusalehmdtayeen@gmail.com"
  access_token = "ya29..zQLmLjbyujJjwV6RVSM2sy-mkeaKu-9"
  list_id = 12
  verbose = TRUE
  content = FALSE
  get_species_from_list(userid, access_token, list_id, verbose, content)
  }
}
\seealso{
\url{https://github.com/phylotastic/phylo_services_docs/tree/master/ServiceDescription}
}
