% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/searchplos.R
\name{searchplos}
\alias{searchplos}
\title{Base function to search PLoS Journals}
\usage{
searchplos(q = NULL, fl = "id", fq = NULL, sort = NULL, start = 0,
  limit = 10, sleep = 6, terms = NULL, fields = NULL, toquery = NULL,
  callopts = NULL, ...)
}
\arguments{
\item{q}{Search terms (character). You can search on specific fields by
doing 'field:your query'. For example, a real query on a specific field would
be 'author:Smith'.}

\item{fl}{Fields to return from search (character) [e.g., 'id,title'],
any combination of search fields (see the dataset \code{plosfields})}

\item{fq}{List specific fields to filter the query on (if NA, all queried).
The options for this parameter are the same as those for the fl parameter.
Note that using this parameter doesn't influence the actual query, but is used
to filter the resuls to a subset of those you want returned. For example,
if you want full articles only, you can do \code{'doc_type:full'}. In another example,
if you want only results from the journal PLOS One, you can do
\code{'cross_published_journal_key:PLoSONE'}. See \code{\link{journalnamekey}} for journal
abbreviations.}

\item{sort}{Sort results according to a particular field, and specify ascending (asc)
or descending (desc) after a space; see examples. For example, to sort the
counter_total_all field in descending fashion, do sort='counter_total_all desc'}

\item{start}{Record to start at (used in combination with limit when
you need to cycle through more results than the max allowed=1000)}

\item{limit}{Number of results to return (integer). Setting \code{limit=0} returns only
metadta.}

\item{sleep}{Number of seconds to wait between requests. No need to use this for
a single call to searchplos. However, if you are using searchplos in a loop or
lapply type call, do sleep parameter is used to prevent your IP address from being
blocked. You can only do 10 requests per minute, so one request every 6 seconds is
about right.}

\item{terms}{DEPRECATED PARAMETER - replaced with the \code{q} param.}

\item{fields}{DEPRECATED PARAMETER - replaced with the \code{fl} param.}

\item{toquery}{DEPRECATED PARAMETER - replaced with the \code{fq} param.}

\item{callopts}{DEPRECATED PARAMETER - replaced with the \code{...} param.}

\item{...}{Optional additional curl options (debugging tools mostly), passed on to
\code{\link[httr]{GET}}}
}
\value{
An object of class "plos", with a list of length two, each element being
a list itself.
}
\description{
Base function to search PLoS Journals
}
\details{
Details:
}
\section{Faceting}{

Read more about faceting here: url{http://wiki.apache.org/solr/SimpleFacetParameters}
}

\section{Website vs. API behavior}{

Don't be surprised if queries you perform in a scripting language, like using \code{rplos}
in R, give different results than when searching for articles on the PLOS website. I am
not sure what exact defaults they use on their website. There are a few things to consider.
You can tweak which types of articles are returned: Try using the \code{article_type}
filter in the \code{fq} parameter. For which journal to search, e.g., do
\code{'cross_published_journal_key:PLoSONE'}. See \code{journalnamekey()} for journal
abbreviations.
}
\examples{
\dontrun{
searchplos(q='ecology', fl=c('id','publication_date'), limit = 2)
searchplos('ecology', fl=c('id','publication_date'), limit = 2)
searchplos('ecology', c('id','title'), limit = 2)

# Get only full article DOIs
out <- searchplos(q="*:*", fl='id', fq='doc_type:full', start=0, limit=250)
head(out$data)

# Get DOIs for only PLoS One articles
out <- searchplos(q="*:*", fl='id', fq='cross_published_journal_key:PLoSONE', start=0, limit=15)
head(out$data)

# Get DOIs for full article in PLoS One
out <- searchplos(q="*:*", fl='id', fq=list('cross_published_journal_key:PLoSONE',
   'doc_type:full'), limit=50)
head(out$data)

# Serch for many q
q <- c('ecology','evolution','science')
lapply(q, function(x) searchplos(x, limit=2))

# Query to get some PLOS article-level metrics, notice difference between two outputs
out <- searchplos(q="*:*", fl=c('id','counter_total_all','alm_twitterCount'),fq='doc_type:full')
out_sorted <- searchplos(q="*:*", fl=c('id','counter_total_all','alm_twitterCount'),
   fq='doc_type:full', sort='counter_total_all desc')
head(out$data)
head(out_sorted$data)

# Show me all articles that have these two words less then about 15 words apart.
searchplos(q='everything:"sports alcohol"~15', fl='title', fq='doc_type:full')

# Now let's try to narrow our results to 7 words apart. Here I'm changing the ~15 to ~7
searchplos(q='everything:"sports alcohol"~7', fl='title', fq='doc_type:full')

# A list of articles about social networks that are popular on a social network
searchplos(q="*:*",fl=c('id','alm_twitterCount'),
   fq=list('doc_type:full','subject:"Social networks"','alm_twitterCount:[100 TO 10000]'),
   sort='counter_total_month desc')

# Now, lets also only look at articles that have seen some activity on twitter.
# Add "fq=alm_twitterCount:[1 TO *]" as a parameter within the fq argument.
searchplos(q='everything:"sports alcohol"~7', fl=c('alm_twitterCount','title'),
   fq=list('doc_type:full','alm_twitterCount:[1 TO *]'))
searchplos(q='everything:"sports alcohol"~7', fl=c('alm_twitterCount','title'),
   fq=list('doc_type:full','alm_twitterCount:[1 TO *]'),
   sort='counter_total_month desc')

# Return partial doc parts
## Return Abstracts only
out <- searchplos(q='*:*', fl=c('doc_partial_body','doc_partial_parent_id'),
   fq=list('doc_type:partial', 'doc_partial_type:Abstract'), limit=3)
## Return Title's only
out <- searchplos(q='*:*', fl=c('doc_partial_body','doc_partial_parent_id'),
   fq=list('doc_type:partial', 'doc_partial_type:Title'), limit=3)

# Remove DOIs for annotations (i.e., corrections)
searchplos(q='*:*', fl=c('id','article_type'),
   fq='-article_type:correction', limit=100)

# Remove DOIs for annotations (i.e., corrections) and Viewpoints articles
searchplos(q='*:*', fl=c('id','article_type'),
   fq=list('-article_type:correction','-article_type:viewpoints'), limit=100)

# Get eissn codes
searchplos(q='*:*', fl=c('id','journal','eissn','cross_published_journal_eissn'),
   fq="doc_type:full", limit = 60)
}
}

