% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{bytau.plot.rq.pen.seq.cv}
\alias{bytau.plot.rq.pen.seq.cv}
\title{Plot of coefficients varying by quantiles for rq.pen.seq.cv object}
\usage{
\method{bytau.plot}{rq.pen.seq.cv}(x, septau = TRUE, cvmin = TRUE, useDefaults = TRUE, ...)
}
\arguments{
\item{x}{An rq.pen.seq.cv object}

\item{septau}{Whether optimal tuning parameters are estimated separately for each quantile.}

\item{cvmin}{Whether the minimum cv error should be used or the one standard error rule.}

\item{useDefaults}{Set to FALSE if you want to use something besides minimum cv or 1se.}

\item{...}{Additional parameters sent to plot()}
}
\value{
Returns plots of coefficient estimates varying by quantile.
}
\description{
Produces plots of how coefficient estimates vary by quantile for models selected by using cross validation.
}
\examples{
 set.seed(1)
 x <- matrix(runif(800),nrow=100)
 y <- 1 + x[,1] - 3*x[,5] + (1+x[,4])*rnorm(100)
 lmcv <- rq.pen.cv(x,y,tau=seq(.1,.9,.1))
 bytau.plot(lmcv)
}
\author{
Ben Sherwood, \email{ben.sherwood@ku.edu}
}
