% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{rq.group.fit}
\alias{rq.group.fit}
\title{Estimates a quantile regression model with a group penalized objective function.}
\usage{
rq.group.fit(
  x,
  y,
  groups,
  tau = 0.5,
  lambda,
  intercept = TRUE,
  penalty = "SCAD",
  alg = "QICD",
  a = 3.7,
  penGroups = NULL,
  ...
)
}
\arguments{
\item{x}{Matrix of predictors.}

\item{y}{Vector of responses.}

\item{groups}{Vector of group assignments.}

\item{tau}{Single quantile to be modeled.}

\item{lambda}{Single value or seperate value for each group.}

\item{intercept}{Whether intercept should be included in the model or not.}

\item{penalty}{Type of penalty used: SCAD, MCP or LASSO.}

\item{alg}{Type of algorithm used: QICD or LP.}

\item{a}{Additional tuning parameter for SCAD and MCP.}

\item{penGroups}{Vector of TRUE and FALSE entries for each group determing if they should be penalized. Default is TRUE for all groups.}

\item{...}{Additional arguments sent to rq.group.lin.prog()}
}
\value{
Returns the following:      
\itemize{    
\item{coefficients}{Coefficients of the model.}
\item{residuals}{ Residuals from the fitted model.}
\item{rho}{Unpenalized portion of the objective function.}
\item{tau}{ Quantile being modeled.}
\item{n}{Sample size.}
\item{intercept}{Whether intercept was included in model.}
}
}
\description{
Warning: function is deprecated and will not be exported in future R packages. Recommend using rq.group.pen() instead. 
Similar to cv.rq.pen function, but uses group penalty. Group penalties use the L1 norm instead of L2 for computational convenience. 
As a result of this the group lasso penalty is the same as the typical lasso penalty and thus you should only use a SCAD or MCP penalty. 
Only the SCAD and MCP penalties incorporate the group structure into the penalty. The group lasso penalty is implemented because it is 
needed for the SCAD and MCP algorithm. We use a group penalty extension of the QICD algorithm presented by Peng and Wang (2015).
}
\references{
\itemize{
\item Yuan, M. and Lin, Y. (2006). Model selection and estimation in regression with grouped variables. \emph{J. R. Statist. Soc. B}, \bold{68}, 49-67.
\item Peng, B. and Wang, L. (2015). An Iterative Coordinate Descent Algorithm for High-Dimensional Nonconvex Penalized Quantile Regression. \emph{Journal of Computational and Graphical Statistics}, \bold{24}, 676-694.
}
}
\author{
Ben Sherwood, \email{ben.sherwood@ku.edu} and Adam Maidman
}
