% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{rq.lasso.fit}
\alias{rq.lasso.fit}
\title{Estimates a quantile regression model with a lasso penalized quanitle loss function.}
\usage{
rq.lasso.fit(
  x,
  y,
  tau = 0.5,
  lambda = NULL,
  weights = NULL,
  intercept = TRUE,
  coef.cutoff = 1e-08,
  method = "br",
  penVars = NULL,
  scalex = TRUE,
  lambda.discard = TRUE,
  ...
)
}
\arguments{
\item{x}{Matrix of predictors.}

\item{y}{Vector of responses.}

\item{tau}{Quantile of interest.}

\item{lambda}{Tuning parameter.}

\item{weights}{Weights for the objective function.}

\item{intercept}{Whether model should include an intercept. Constant does not need to be included in "x".}

\item{coef.cutoff}{Coefficients below this value will be set to zero.}

\item{method}{Use method "br" or "fn" as outlined in quantreg package. We have found "br" to be more stable for penalized regression problems.}

\item{penVars}{Variables that should be penalized. With default value of NULL all variables are penalized.}

\item{scalex}{If set to true the predictors will be scaled to have mean zero and standard deviation of one before fitting the model. The output returned will be on the original scale of the data.}

\item{lambda.discard}{If TRUE lambda sequence will stop early if for small values of lambda the estimates do not change much.}

\item{...}{Additional items to be sent to rq. Note this will have to be done carefully as rq is run on the augmented data to account for penalization and could provide strange results if this is not taken into account.}
}
\value{
Returns the following:
\itemize{
\item{coefficients}{ Coefficients from the penalized model.} 
\item{PenRho}{ Penalized objective function value.}
\item{residuals}{ Residuals from the model.}
\item{rho}{ Objective function evaluation without the penalty.}
\item{tau}{ Conditional quantile being modeled.}
\item{n}{ Sample size.}  
}
}
\description{
Fits a quantile regression model with the LASSO penalty. Uses the augmented data approach similar to the proposal in Sherwood and Wang (2016).
}
\examples{
x <- matrix(rnorm(800),nrow=100)
y <- 1 + x[,1] - 3*x[,5] + rnorm(100)
lassoModel <- rq.lasso.fit(x,y,lambda=.1)

}
\references{
\itemize{
\item Tibshirani, R. (1996). Regression shrinkage and selection via the lasso. \emph{Journal of the Royal Statistical Society. Series B}, \bold{58}, 267--288.
\item Wu, Y. and Liu, Y. (2009). Variable selection in quantile regression. \emph{Statistica Sinica}, \bold{19}, 801--817.  
\item Sherwood, B. and Wang, L. (2016) Partially linear additive quantile regression in ultra-high dimension. \emph{Annals of Statistics} \bold{44}, 288--317. 
}
}
