% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop_project.R
\name{ex_data_table.relop_project}
\alias{ex_data_table.relop_project}
\title{Implement projection operator.}
\usage{
\method{ex_data_table}{relop_project}(optree, ..., tables = list(),
  source_usage = NULL, source_limit = NULL, env = parent.frame())
}
\arguments{
\item{optree}{relop operations tree.}

\item{...}{not used, force later arguments to bind by name.}

\item{tables}{named list map from table names used in nodes to data.tables and data.frames.}

\item{source_usage}{list mapping source table names to vectors of columns used.}

\item{source_limit}{if not null limit all table sources to no more than this many rows (used for debugging).}

\item{env}{environment to work in.}
}
\description{
\code{data.table} based implementation.
}
\examples{

dL <- build_frame(
  "subjectID", "surveyCategory"     , "assessmentTotal" |
    1          , "withdrawal behavior", 5                 |
    1          , "positive re-framing", 2                 |
    2          , "withdrawal behavior", 3                 |
    2          , "positive re-framing", 4                 )
test_p <- local_td(dL) \%.>\%
  project_nse(.,
              maxscore = max(assessmentTotal),
              groupby = 'subjectID',
              count = n())
cat(format(test_p))
ex_data_table(test_p)

}
