% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop_list.R
\name{materialize_relop_list_stages}
\alias{materialize_relop_list_stages}
\title{Materialize a stages list on a database.}
\usage{
materialize_relop_list_stages(db, collector, ..., narrow = TRUE,
  limit = NULL, source_limit = NULL, overwrite = TRUE,
  temporary = TRUE)
}
\arguments{
\item{db}{database connecton (rquery_db_info class preferred, or DBI connections).}

\item{collector}{a rquery::relop_list}

\item{...}{force later arguments to bind by name.}

\item{narrow}{logical, if TRUE add select_columns() to narrow stages.}

\item{limit}{numeric if not NULL result limit (to use this, last statement must not have a limit).}

\item{source_limit}{numeric if not NULL limit sources to this many rows.}

\item{overwrite}{logical if TRUE drop an previous table.}

\item{temporary}{logical if TRUE try to create a temporary table.}
}
\value{
a rquery::relop_table_source representing ops's materialization.
}
\description{
For how to use please see here \url{https://github.com/WinVector/rquery/blob/master/extras/query_growth/query_growth.md}.
}
\examples{

if(requireNamespace("DBI", quietly = TRUE) &&
   requireNamespace("RSQLite", quietly = TRUE) ) {

  rsqlite_connection <- DBI::dbConnect(RSQLite::SQLite(),
                                       ":memory:")
  db <- rquery_db_info(
    connection = rsqlite_connection,
    is_dbi = TRUE
    )

  collector <- make_relop_list()
  d <- rq_copy_to(db, "d", data.frame(x = 1, y = 2),
                  temporary = TRUE, overwrite = TRUE)
  ops1 <- d \%.>\%
    extend(., z \%:=\% x + y) \%.>\%
    collector
  ops2 <- ops1 \%.>\%
    extend(., z2 \%:=\% x / y) \%.>\%
    collector
  get_relop_list_stages(collector)
  res <- materialize_relop_list_stages(db, collector)
  res
  execute(db, res)

  DBI::dbDisconnect(rsqlite_connection)
}

}
\seealso{
\code{\link{make_relop_list}}, \code{\link{add_relop}}, \code{\link{get_relop_list_stages}}
}
