% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta_join.R
\name{theta_join}
\alias{theta_join}
\alias{theta_join_nse}
\title{Make a theta_join node.}
\usage{
theta_join(a, b, expr, ..., jointype = "INNER", suffix = c("_a", "_b"),
  env = parent.frame())

theta_join_nse(a, b, expr, ..., jointype = "INNER", suffix = c("_a",
  "_b"), env = parent.frame())
}
\arguments{
\item{a}{source to select from.}

\item{b}{source to select from.}

\item{expr}{unquoted join condition}

\item{...}{force later arguments to be by name}

\item{jointype}{type of join ('INNER', 'LEFT', 'RIGHT', 'FULL').}

\item{suffix}{character length 2, suffices to disambiguate columns.}

\item{env}{environment to look for values in.}
}
\value{
theta_join node.
}
\description{
Theta join is a join on an arbitrary predicate.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d1 <- rq_copy_to(my_db, 'd1',
                    data.frame(AUC = 0.6, R2 = 0.2))
  d2 <- rq_copy_to(my_db, 'd2',
                    data.frame(AUC2 = 0.4, R2 = 0.3))
  optree <- theta_join(d1, d2, AUC >= AUC2)
  cat(format(optree))
  sql <- to_sql(optree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
