% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/union_all.R
\name{unionall}
\alias{unionall}
\title{Make an unionall node (not a relational operation).}
\usage{
unionall(sources, env = parent.frame())
}
\arguments{
\item{sources}{list of relop trees or list of data.frames}

\item{env}{environment to look to.}
}
\value{
order_by node or altered data.frame.
}
\description{
Concatenate tables by rows.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2))
  optree <- unionall(list(d, d, d))
  cat(format(optree))
  sql <- to_sql(optree, my_db, limit = 2)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
