% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend.R
\name{extend}
\alias{extend}
\alias{extend_nse}
\title{Extend data by adding more columns.}
\usage{
extend(
  source,
  ...,
  partitionby = NULL,
  orderby = NULL,
  reverse = NULL,
  display_form = NULL,
  env = parent.frame()
)

extend_nse(
  source,
  ...,
  partitionby = NULL,
  orderby = NULL,
  reverse = NULL,
  display_form = NULL,
  env = parent.frame()
)
}
\arguments{
\item{source}{source to select from.}

\item{...}{new column assignment expressions.}

\item{partitionby}{partitioning (window function) terms.}

\item{orderby}{ordering (in window function) terms.}

\item{reverse}{reverse ordering (in window function) terms.}

\item{display_form}{chacter presentation form}

\item{env}{environment to look for values in.}
}
\value{
extend node.
}
\description{
Create a node similar to a Codd extend relational operator (add derived columns).
}
\details{
Partitionby and orderby can only be used with a database that supports window-functions
(such as PostgreSQL, Spark, and so on).

Supports bquote() .()-style name abstraction (please see here: \url{https://github.com/WinVector/rquery/blob/master/Examples/Substitution/Substitution.md}).

Note: if any window/aggregation functions are present then at least one of partitionby or orderby
must be non empty.  For this purpose partitionby=1 is allowed and means "single partition on the constant 1."
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2))
  NEWCOL <- as.name("v")
  NEWVALUE = "zz"
  optree <- extend(d, .(NEWCOL) \%:=\% ifelse(AUC>0.5, R2, 1.0), .(NEWVALUE) \%:=\% 6)
  cat(format(optree))
  sql <- to_sql(optree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
