% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim-names.R
\name{dim-names}
\alias{dim-names}
\alias{rray_dim_names}
\alias{rray_dim_names<-}
\alias{rray_set_dim_names}
\alias{rray_axis_names}
\alias{rray_axis_names<-}
\alias{rray_set_axis_names}
\alias{rray_row_names}
\alias{rray_row_names<-}
\alias{rray_set_row_names}
\alias{rray_col_names}
\alias{rray_col_names<-}
\alias{rray_set_col_names}
\title{Dimension names}
\usage{
rray_dim_names(x)

rray_dim_names(x) <- value

rray_set_dim_names(x, dim_names)

rray_axis_names(x, axis)

rray_axis_names(x, axis) <- value

rray_set_axis_names(x, axis, names, meta = NULL)

rray_row_names(x)

rray_row_names(x) <- value

rray_set_row_names(x, names, meta = NULL)

rray_col_names(x)

rray_col_names(x) <- value

rray_set_col_names(x, names, meta = NULL)
}
\arguments{
\item{x}{The object to extract the dimension names for.}

\item{value}{For \code{rray_dim_names<-()}, a list containing either character
vectors or \code{NULL} corresponding to the new dimension names
to use for \code{x}. Otherwise, identical to \code{names}.}

\item{dim_names}{A list of either character vectors or \code{NULL} representing
the new dim names of \code{x}. If \code{NULL} is supplied, the dim names of \code{x} are
removed.}

\item{axis}{A single integer. The axis to select dimension names for.}

\item{names}{A character vector of new dimension names
for the \code{axis} dimension. This is also allowed to be \code{NULL} to remove
dimension names for the specified axis.}

\item{meta}{A single character representing an optional "meta" name
assigned to the \code{axis} names. If \code{NULL}, the current meta name is kept.}
}
\value{
\code{rray_dim_names()} returns a list of dimension names. The other names
functions return character vectors, or \code{NULL}, corresponding to the
names of a particular axis.
}
\description{
This family of functions allows you to get and set dimension names in various
ways.
\itemize{
\item \code{rray_dim_names()} returns a list of the dimension names.
\item \code{rray_axis_names()} returns a character vector or \code{NULL} containing the
names corresponding to the \code{axis} dimension.
\item \code{rray_row_names()} and \code{rray_col_names()} are helpers for getting the
row and column names respectively.
\item Each of these four functions also has "set" variants: a functional form
(i.e. \code{rray_set_row_names()}), and an assignment
form (i.e. \code{rray_row_names<-()}).
}
}
\details{
Unlike \code{dimnames()} which can return \code{NULL}, \code{rray_dim_names()} always returns a
list the same length as the dimensionality of \code{x}. If any dimensions do not
have names, \code{NULL} is returned for that element of the list. This
results in an object that's length always matches the dimensionality of \code{x}.
}
\examples{
x <- rray(1:10, c(5, 2))
rray_dim_names(x) <- list(letters[1:5], NULL)
x
rray_dim_names(x)

# 3D object, so 3 dim name elements
rray_dim_names(rray(1, dim = c(1, 1, 1)))

# Vectors are treated as 1D arrays
vec <- c(x = 1, y = 2)
rray_dim_names(vec)

# You can add dim names more easily
# using rray_set_axis_names()
# and the pipe operator
library(magrittr)
y <- rray(1, c(1, 2, 1)) \%>\%
  rray_set_axis_names(1, "r1") \%>\%
  rray_set_axis_names(2, c("c1", "c2")) \%>\%
  rray_set_axis_names(3, "3rd dim")

y

# You can set also set axis names to `NULL` to reset them
rray_set_axis_names(y, 2, NULL)

# You can set the "meta" names of an axis as well
rray_set_axis_names(y, 1, "r1", "row names")

}
