/*
 * Decompiled with CFR 0.152.
 */
package com.github.egonw.rrdf;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class StringMatrix {
    private Map<Integer, Map<Integer, String>> matrix;
    private int cols = 0;
    private int rows = 0;
    private Map<Integer, String> rowHeaders;
    private Map<Integer, String> colHeaders;

    private void checkDimensions(int n, int n2) {
        this.checkRows(n);
        this.checkCols(n2);
    }

    private void checkRows(int n) {
        if (n < 0 || n > this.rows) {
            throw new ArrayIndexOutOfBoundsException("Incorrect row number: " + n);
        }
    }

    private void checkCols(int n) {
        if (n < 0 || n > this.cols) {
            throw new ArrayIndexOutOfBoundsException("Incorrect column number: " + n);
        }
    }

    public String get(int n, int n2) {
        this.checkDimensions(n, n2);
        if (this.matrix == null) {
            return "";
        }
        Map<Integer, String> map = this.matrix.get(n);
        if (map == null) {
            return "";
        }
        return map.get(n2);
    }

    public String get(int n, String string) {
        this.checkRows(n);
        return this.get(n, this.getColumnNumber(string));
    }

    public int getColumnCount() {
        return this.cols;
    }

    public int getColumnNumber(String string) {
        if (this.colHeaders != null) {
            for (Integer n : this.colHeaders.keySet()) {
                String string2 = this.colHeaders.get(n);
                if (string2 == null || !string2.equals(string)) continue;
                return n;
            }
        }
        throw new IllegalAccessError("No column found with this label.");
    }

    public String getColumnName(int n) {
        this.checkCols(n);
        if (this.colHeaders == null) {
            return "";
        }
        return this.colHeaders.get(n);
    }

    public int getRowCount() {
        return this.rows;
    }

    public String getRowName(int n) {
        this.checkRows(n);
        if (this.rowHeaders == null) {
            return "";
        }
        return this.rowHeaders.get(n);
    }

    public boolean hasColHeader() {
        return this.colHeaders != null;
    }

    public boolean hasRowHeader() {
        return this.rowHeaders != null;
    }

    public void set(int n, int n2, String string) {
        Map<Integer, String> map;
        if (n > this.rows) {
            this.rows = n;
        }
        if (n2 > this.cols) {
            this.cols = n2;
        }
        this.checkDimensions(n, n2);
        if (this.matrix == null) {
            this.matrix = new Hashtable<Integer, Map<Integer, String>>(n);
        }
        if ((map = this.matrix.get(n)) == null) {
            map = new Hashtable<Integer, String>(n2);
            this.matrix.put(n, map);
        }
        map.put(n2, string);
    }

    public void setColumnName(int n, String string) {
        if (n > this.cols) {
            this.cols = n;
        }
        this.checkCols(n);
        if (this.colHeaders == null) {
            this.colHeaders = new Hashtable<Integer, String>();
        }
        this.colHeaders.put(n, string);
    }

    public void setRowName(int n, String string) {
        this.checkRows(n);
        if (this.rowHeaders == null) {
            this.rowHeaders = new Hashtable<Integer, String>();
        }
        this.rowHeaders.put(n, string);
    }

    public void setSize(int n, int n2) {
        this.rows = n;
        this.cols = n2;
    }

    public void set(int n, String string, String string2) {
        this.checkRows(n);
        this.set(n, this.getColumnNumber(string), string2);
    }

    public List<String> getColumn(int n) {
        this.checkCols(n);
        int n2 = this.getRowCount();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i = 1; i <= n2; ++i) {
            String string = this.get(i, n);
            arrayList.add(string == null ? "" : string);
        }
        return arrayList;
    }

    public List<String> getColumn(String string) {
        int n = this.getColumnNumber(string);
        return this.getColumn(n);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (this.hasColHeader()) {
            stringBuffer.append("[");
            for (n = 1; n <= this.getColumnCount(); ++n) {
                stringBuffer.append('\"');
                String string = this.getColumnName(n);
                stringBuffer.append(string == null ? "" : string);
                stringBuffer.append('\"');
                if (n >= this.getColumnCount()) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append("],\n");
        }
        for (n = 1; n <= this.getRowCount(); ++n) {
            if (this.hasRowHeader()) {
                stringBuffer.append('\"');
                String string = this.getRowName(n);
                stringBuffer.append(string == null ? "" : string);
                stringBuffer.append("\": ");
            }
            stringBuffer.append('[');
            for (int i = 1; i <= this.getColumnCount(); ++i) {
                stringBuffer.append('\"');
                String string = this.get(n, i);
                stringBuffer.append(string == null ? "" : string);
                stringBuffer.append('\"');
                if (i >= this.getColumnCount()) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            if (n < this.getRowCount()) {
                stringBuffer.append(',');
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append(']');
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public List<String> getColumnNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getColumnCount());
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            arrayList.add(this.getColumnName(i));
        }
        return arrayList;
    }

    public List<String> getRowNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getRowCount());
        for (int i = 1; i <= this.getRowCount(); ++i) {
            arrayList.add(this.getRowName(i));
        }
        return arrayList;
    }
}

