/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.QuerySolutionBase;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultBinding
extends QuerySolutionBase {
    Binding binding;
    Model model;

    public ResultBinding(Model _model, Binding _binding) {
        this.model = _model;
        this.binding = _binding;
    }

    @Override
    protected RDFNode _get(String varName) {
        Node n = this.binding.get(Var.alloc(varName));
        if (n == null) {
            return null;
        }
        return ModelUtils.convertGraphNodeToRDFNode(n, this.model);
    }

    @Override
    protected boolean _contains(String varName) {
        return this.binding.contains(Var.alloc(varName));
    }

    @Override
    public Iterator<String> varNames() {
        ArrayList<String> x = new ArrayList<String>();
        Iterator<Var> iter = this.binding.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            x.add(v.getVarName());
        }
        return x.iterator();
    }

    public Binding getBinding() {
        return this.binding;
    }

    public String toString() {
        if (this.binding == null) {
            return "<no binding>";
        }
        return this.binding.toString();
    }

    public static boolean equals(ResultBinding rb1, ResultBinding rb2) {
        return BindingBase.equals(rb1.getBinding(), rb2.getBinding());
    }
}

