/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.library;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.E_Regex;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class FN_Matches
implements Function {
    E_Regex regex = null;
    ExprList myArgs = null;

    public void build(String uri, ExprList args) {
        if (args.size() != 3 && args.size() != 2) {
            throw new ExprEvalException("matches: Wrong number of arguments: Wanted 2 or 3, got " + args.size());
        }
        this.myArgs = args;
    }

    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        if (this.myArgs != args) {
            throw new ARQInternalErrorException("matches: Arguments have changed since checking");
        }
        Expr expr = args.get(0);
        E_Regex regexEval = this.regex;
        if (regexEval == null) {
            Expr e1 = args.get(1);
            Expr e2 = null;
            if (args.size() == 3) {
                e2 = args.get(2);
            }
            String pattern = e1.eval(binding, env).getString();
            String flags = e2 == null ? null : e2.eval(binding, env).getString();
            regexEval = new E_Regex(expr, pattern, flags);
            if (e1 instanceof NodeValue && (e2 == null || e2 instanceof NodeValue)) {
                this.regex = regexEval;
            }
        }
        NodeValue nv = regexEval.eval(binding, env);
        return nv;
    }
}

