/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import com.hp.hpl.jena.sparql.graph.NodeTransformLib;
import com.hp.hpl.jena.sparql.path.Path;
import java.util.ArrayList;
import java.util.List;

class NodeTransformOp
extends TransformCopy {
    private final NodeTransform transform;

    NodeTransformOp(NodeTransform transform) {
        this.transform = transform;
    }

    public Op transform(OpTriple opTriple) {
        Triple t2 = NodeTransformLib.transform(this.transform, opTriple.getTriple());
        if (t2 == opTriple.getTriple()) {
            return super.transform(opTriple);
        }
        return new OpTriple(t2);
    }

    public Op transform(OpFilter opFilter, Op subOp) {
        ExprList exprList = opFilter.getExprs();
        ExprList exprList2 = NodeTransformLib.transform(this.transform, exprList);
        return OpFilter.filter(exprList2, subOp);
    }

    public Op transform(OpBGP opBGP) {
        BasicPattern bgp2 = NodeTransformLib.transform(this.transform, opBGP.getPattern());
        if (bgp2 == opBGP.getPattern()) {
            return super.transform(opBGP);
        }
        return new OpBGP(bgp2);
    }

    public Op transform(OpPath opPath) {
        TriplePath tp2;
        TriplePath tp = opPath.getTriplePath();
        Node s = tp.getSubject();
        Node s1 = this.transform.convert(s);
        Node o = tp.getObject();
        Node o1 = this.transform.convert(o);
        if (s1 == s || o1 == o) {
            return opPath;
        }
        Path path = tp.getPath();
        if (path != null) {
            tp2 = new TriplePath(s1, path, o1);
        } else {
            Triple t = new Triple(s1, tp.getPredicate(), o1);
            tp2 = new TriplePath(t);
        }
        return new OpPath(tp2);
    }

    public Op transform(OpQuadPattern opQuadPattern) {
        BasicPattern bgp2 = NodeTransformLib.transform(this.transform, opQuadPattern.getBasicPattern());
        Node g2 = opQuadPattern.getGraphNode();
        if ((g2 = this.transform.convert(g2)) == opQuadPattern.getGraphNode() && bgp2 == opQuadPattern.getBasicPattern()) {
            return super.transform(opQuadPattern);
        }
        return new OpQuadPattern(g2, bgp2);
    }

    public Op transform(OpGraph opGraph, Op subOp) {
        Node g2 = this.transform.convert(opGraph.getNode());
        if (g2 == opGraph.getNode()) {
            return super.transform(opGraph, subOp);
        }
        return new OpGraph(g2, subOp);
    }

    public Op transform(OpDatasetNames opDatasetNames) {
        Node g2 = this.transform.convert(opDatasetNames.getGraphNode());
        if (g2 == opDatasetNames.getGraphNode()) {
            return super.transform(opDatasetNames);
        }
        return new OpDatasetNames(g2);
    }

    public Op transform(OpTable opTable) {
        if (opTable.isJoinIdentity()) {
            return opTable;
        }
        throw new ARQNotImplemented();
    }

    public Op transform(OpProject opProject, Op subOp) {
        List<Var> x = opProject.getVars();
        List<Var> x2 = NodeTransformLib.transformVars(this.transform, x);
        return new OpProject(subOp, x2);
    }

    public Op transform(OpAssign opAssign, Op subOp) {
        VarExprList varExprList = opAssign.getVarExprList();
        VarExprList varExprList2 = NodeTransformLib.transform(this.transform, varExprList);
        return OpAssign.assign(subOp, varExprList2);
    }

    public Op transform(OpExtend opExtend, Op subOp) {
        VarExprList varExprList = opExtend.getVarExprList();
        VarExprList varExprList2 = NodeTransformLib.transform(this.transform, varExprList);
        return OpExtend.extend(subOp, varExprList2);
    }

    public Op transform(OpGroup opGroup, Op subOp) {
        VarExprList groupVars = NodeTransformLib.transform(this.transform, opGroup.getGroupVars());
        ArrayList<ExprAggregator> aggregators = new ArrayList<ExprAggregator>();
        for (ExprAggregator agg : opGroup.getAggregators()) {
            aggregators.add(agg.applyNodeTransform(this.transform));
        }
        return new OpGroup(subOp, groupVars, aggregators);
    }
}

