/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.resultset.JSONInput;
import com.hp.hpl.jena.sparql.resultset.RDFInput;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.ResultSetFormat;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.resultset.SortedResultSet;
import com.hp.hpl.jena.sparql.resultset.XMLInput;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderTable;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import java.util.List;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetFactory {
    public static ResultSet load(String filenameOrURI) {
        return ResultSetFactory.load(filenameOrURI, null);
    }

    public static ResultSet load(String filenameOrURI, ResultSetFormat format) {
        if (format == null) {
            format = ResultSetFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultSetFormat.syntaxXML;
        }
        if (format.equals(ResultSetFormat.syntaxText)) {
            Log.fatal(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        InputStream in = FileManager.get().open(filenameOrURI);
        if (in == null) {
            throw new NotFoundException("Not found: " + filenameOrURI);
        }
        return ResultSetFactory.load(in, format);
    }

    public static ResultSet load(InputStream input, ResultSetFormat format) {
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultSetFormat.syntaxXML;
        }
        if (format.equals(ResultSetFormat.syntaxText)) {
            Log.warn(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultSetFormat.syntaxXML)) {
            return ResultSetFactory.fromXML(input);
        }
        if (format.equals(ResultSetFormat.syntaxRDF_XML)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null);
            return ResultSetFactory.fromRDF(m);
        }
        if (format.equals(ResultSetFormat.syntaxRDF_TURTLE)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "TURTLE");
            return ResultSetFactory.fromRDF(m);
        }
        if (format.equals(ResultSetFormat.syntaxRDF_N3)) {
            Model m = ModelFactory.createDefaultModel();
            m.read(input, null, "N3");
            return ResultSetFactory.fromRDF(m);
        }
        if (format.equals(ResultSetFormat.syntaxJSON)) {
            return JSONInput.fromJSON(input);
        }
        Log.warn(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static Model loadAsModel(String filenameOrURI) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, null);
    }

    public static Model loadAsModel(Model model, String filenameOrURI) {
        return ResultSetFactory.loadAsModel(model, filenameOrURI, null);
    }

    public static Model loadAsModel(String filenameOrURI, ResultSetFormat format) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, format);
    }

    public static Model loadAsModel(Model model, String filenameOrURI, ResultSetFormat format) {
        if (model == null) {
            model = GraphFactory.makeDefaultModel();
        }
        if (format == null) {
            format = ResultSetFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultSetFormat.syntaxXML;
        }
        if (format.equals(ResultSetFormat.syntaxText)) {
            Log.fatal(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultSetFormat.syntaxXML) || format.equals(ResultSetFormat.syntaxJSON)) {
            InputStream in = null;
            try {
                in = FileManager.get().open(filenameOrURI);
                if (in == null) {
                    throw new NotFoundException(filenameOrURI);
                }
            }
            catch (NotFoundException ex) {
                throw new NotFoundException("File not found: " + filenameOrURI);
            }
            SPARQLResult x = null;
            x = format.equals(ResultSetFormat.syntaxJSON) ? JSONInput.make(in, GraphFactory.makeDefaultModel()) : XMLInput.make(in, GraphFactory.makeDefaultModel());
            if (x.isResultSet()) {
                ResultSetFormatter.asRDF(model, x.getResultSet());
            } else {
                ResultSetFormatter.asRDF(model, x.getBooleanResult());
            }
            return model;
        }
        if (format.isRDFGraphSyntax()) {
            return FileManager.get().readModel(model, filenameOrURI);
        }
        Log.fatal(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static SPARQLResult result(String filenameOrURI) {
        return ResultSetFactory.result(filenameOrURI, null);
    }

    public static SPARQLResult result(String filenameOrURI, ResultSetFormat format) {
        if (format == null) {
            format = ResultSetFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultSetFormat.syntaxXML;
        }
        if (format.equals(ResultSetFormat.syntaxText)) {
            Log.fatal(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultSetFormat.syntaxXML) || format.equals(ResultSetFormat.syntaxJSON)) {
            InputStream in = null;
            try {
                in = FileManager.get().open(filenameOrURI);
                if (in == null) {
                    throw new NotFoundException(filenameOrURI);
                }
            }
            catch (NotFoundException ex) {
                throw new NotFoundException("File not found: " + filenameOrURI);
            }
            Object x = null;
            if (format.equals(ResultSetFormat.syntaxJSON)) {
                return JSONInput.make(in, GraphFactory.makeDefaultModel());
            }
            return XMLInput.make(in, GraphFactory.makeDefaultModel());
        }
        if (format.isRDFGraphSyntax()) {
            Model model = FileManager.get().loadModel(filenameOrURI);
            return new SPARQLResult(model);
        }
        Log.fatal(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static ResultSet fromXML(InputStream in) {
        return XMLInput.fromXML(in);
    }

    public static ResultSet fromXML(String str2) {
        return XMLInput.fromXML(str2);
    }

    public static ResultSet fromRDF(Model model) {
        return new RDFInput(model);
    }

    public static ResultSet fromJSON(InputStream in) {
        return JSONInput.fromJSON(in);
    }

    public static ResultSet fromSSE(InputStream in) {
        Item item = SSE.parse(in);
        Log.warn(ResultSet.class, "Reading SSE result set not full implemented");
        BuilderTable.build(item);
        return null;
    }

    public static ResultSet makeResults(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(ResultSet resultSet) {
        return new ResultSetMem(resultSet);
    }

    public static ResultSet makeSorted(ResultSet resultSet, List<SortCondition> conditions) {
        return new SortedResultSet(resultSet, conditions);
    }

    public static ResultSetRewindable copyResults(ResultSet results) {
        return new ResultSetMem(results);
    }

    public static ResultSet create(QueryIterator queryIterator, List<String> vars) {
        return new ResultSetStream(vars, null, queryIterator);
    }
}

