/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.util.Iterator;
import org.openjena.atlas.lib.Cache;
import org.openjena.atlas.lib.CacheFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetImpl
implements Dataset {
    protected DatasetGraph dsg = null;
    private Model defaultModel = null;
    private Cache<String, Model> cache = CacheFactory.createCache(0.75f, 20);

    public DatasetImpl(Model model) {
        this.defaultModel = model;
        this.dsg = DatasetGraphFactory.create(model.getGraph());
    }

    public DatasetImpl(DatasetGraph dsg) {
        this.dsg = dsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getDefaultModel() {
        DatasetImpl datasetImpl = this;
        synchronized (datasetImpl) {
            if (this.defaultModel == null) {
                this.defaultModel = this.graph2model(this.dsg.getDefaultGraph());
            }
            return this.defaultModel;
        }
    }

    @Override
    public Lock getLock() {
        return this.dsg.getLock();
    }

    @Override
    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        DatasetImpl datasetImpl = this;
        synchronized (datasetImpl) {
            Model m = this.cache.get(uri);
            if (m == null) {
                m = this.graph2model(this.dsg.getGraph(Node.createURI((String)uri)));
                this.cache.put(uri, m);
            }
            return m;
        }
    }

    private static void checkGraphName(String uri) {
        if (uri == null) {
            throw new ARQException("null for graph name");
        }
    }

    @Override
    public boolean containsNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        return this.dsg.containsGraph(Node.createURI((String)uri));
    }

    @Override
    public void close() {
        this.cache = null;
        this.dsg.close();
    }

    @Override
    public Iterator<String> listNames() {
        return NodeUtils.nodesToURIs(this.dsg.listGraphNodes());
    }

    private Model graph2model(Graph graph) {
        return ModelFactory.createModelForGraph((Graph)graph);
    }
}

