/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.tokens;

import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.util.NoSuchElementException;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.io.PeekReader;
import org.openjena.riot.RiotParseException;
import org.openjena.riot.system.RiotChars;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenChecker;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;

public final class TokenizerText
implements Tokenizer {
    public static final int CTRL_CHAR = 42;
    public static boolean Checking = false;
    private Token token = null;
    private final StringBuilder stringBuilder = new StringBuilder(200);
    private final PeekReader reader;
    private boolean finished = false;
    private TokenChecker checker = null;

    TokenizerText(PeekReader reader) {
        this.reader = reader;
    }

    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.token != null) {
            return true;
        }
        try {
            this.skip();
            if (this.reader.eof()) {
                this.finished = true;
                return false;
            }
            this.token = this.parseToken();
            if (this.token == null) {
                this.finished = true;
                return false;
            }
            return true;
        }
        catch (AtlasException ex) {
            if (ex.getCause().getClass() == MalformedInputException.class) {
                throw new RiotParseException("Bad character encoding", this.reader.getLineNum(), this.reader.getColNum());
            }
            throw new RiotParseException("Bad input stream", this.reader.getLineNum(), this.reader.getColNum());
        }
    }

    public final Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Token t = this.token;
        this.token = null;
        return t;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public TokenChecker getChecker() {
        return this.checker;
    }

    public void setChecker(TokenChecker checker) {
        this.checker = checker;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private void skip() {
        int ch = -1;
        while (true) {
            if (this.reader.eof()) {
                return;
            }
            ch = this.reader.peekChar();
            if (ch == 35) {
                this.reader.readChar();
                while ((ch = this.reader.peekChar()) != -1 && !RiotChars.isNewlineChar(ch)) {
                    this.reader.readChar();
                }
            }
            if (!RiotChars.isWhitespace(ch)) break;
            this.reader.readChar();
        }
    }

    private Token parseToken() {
        this.token = new Token(this.getLine(), this.getColumn());
        int ch = this.reader.peekChar();
        if (ch == 60) {
            this.reader.readChar();
            this.token.setImage(this.allBetween(60, 62, false, false));
            this.token.setType(TokenType.IRI);
            if (Checking) {
                this.checkURI(this.token.getImage());
            }
            return this.token;
        }
        if (ch == 39 || ch == 34) {
            this.reader.readChar();
            int ch2 = this.reader.peekChar();
            if (ch2 == ch) {
                this.reader.readChar();
                int ch3 = this.reader.peekChar();
                if (ch3 == ch) {
                    this.reader.readChar();
                    this.token.setImage(this.readLongString(ch, false));
                    TokenType tt = ch == 39 ? TokenType.LONG_STRING1 : TokenType.LONG_STRING2;
                    this.token.setType(tt);
                } else {
                    this.token.setImage("");
                    this.token.setType(ch == 39 ? TokenType.STRING1 : TokenType.STRING2);
                }
            } else {
                this.token.setImage(this.allBetween(ch, ch, true, false));
                this.token.setType(ch == 39 ? TokenType.STRING1 : TokenType.STRING2);
            }
            if (this.reader.peekChar() == 64) {
                this.reader.readChar();
                this.token.setImage2(this.langTag());
                this.token.setType(TokenType.LITERAL_LANG);
                if (Checking) {
                    this.checkLiteralLang(this.token.getImage(), this.token.getImage2());
                }
            } else if (this.reader.peekChar() == 94) {
                this.expect("^^");
                int nextCh = this.reader.peekChar();
                if (RiotChars.isWhitespace(nextCh)) {
                    this.exception("No whitespace after ^^ in literal with datatype");
                }
                Token mainToken = this.token;
                Token subToken = this.parseToken();
                if (!subToken.isIRI()) {
                    this.exception("Datatype URI required after ^^ - URI or prefixed name expected");
                }
                this.token = mainToken;
                this.token.setSubToken(subToken);
                this.token.setType(TokenType.LITERAL_DT);
                if (Checking) {
                    this.checkLiteralDT(this.token.getImage(), subToken);
                }
            } else if (Checking) {
                this.checkString(this.token.getImage());
            }
            return this.token;
        }
        if (ch == 95) {
            this.expect("_:");
            this.token.setImage(this.readBlankNodeLabel());
            this.token.setType(TokenType.BNODE);
            if (Checking) {
                this.checkBlankNode(this.token.getImage());
            }
            return this.token;
        }
        if (ch == 42) {
            this.reader.readChar();
            this.token.setType(TokenType.CNTRL);
            ch = this.reader.readChar();
            if (ch == -1) {
                this.exception("EOF found after 42");
            }
            this.token.cntrlCode = (char)ch;
            if (Checking) {
                this.checkControl(this.token.cntrlCode);
            }
            return this.token;
        }
        if (ch == 64) {
            this.reader.readChar();
            this.token.setType(TokenType.DIRECTIVE);
            this.token.setImage(this.readWord(false));
            if (Checking) {
                this.checkDirective(this.token.cntrlCode);
            }
            return this.token;
        }
        if (ch == 63) {
            this.reader.readChar();
            this.token.setType(TokenType.VAR);
            this.token.setImage(this.readWord(true));
            if (Checking) {
                this.checkVariable(this.token.getImage());
            }
            return this.token;
        }
        switch (ch) {
            case 46: {
                this.reader.readChar();
                ch = this.reader.peekChar();
                if (RiotChars.range(ch, '0', '9')) {
                    this.reader.pushbackChar(46);
                    this.readNumber();
                    return this.token;
                }
                this.token.setType(TokenType.DOT);
                return this.token;
            }
            case 59: {
                this.reader.readChar();
                this.token.setType(TokenType.SEMICOLON);
                this.token.setImage(';');
                return this.token;
            }
            case 44: {
                this.reader.readChar();
                this.token.setType(TokenType.COMMA);
                this.token.setImage(',');
                return this.token;
            }
            case 123: {
                this.reader.readChar();
                this.token.setType(TokenType.LBRACE);
                this.token.setImage('{');
                return this.token;
            }
            case 125: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACE);
                this.token.setImage('}');
                return this.token;
            }
            case 40: {
                this.reader.readChar();
                this.token.setType(TokenType.LPAREN);
                this.token.setImage('(');
                return this.token;
            }
            case 41: {
                this.reader.readChar();
                this.token.setType(TokenType.RPAREN);
                this.token.setImage(')');
                return this.token;
            }
            case 91: {
                this.reader.readChar();
                this.token.setType(TokenType.LBRACKET);
                this.token.setImage('[');
                return this.token;
            }
            case 93: {
                this.reader.readChar();
                this.token.setType(TokenType.RBRACKET);
                this.token.setImage(']');
                return this.token;
            }
            case 61: {
                this.reader.readChar();
                this.token.setType(TokenType.EQUALS);
                this.token.setImage('=');
                return this.token;
            }
            case 95: {
                this.reader.readChar();
                this.token.setType(TokenType.UNDERSCORE);
                this.token.setImage('_');
                return this.token;
            }
            case 60: {
                this.reader.readChar();
                this.token.setType(TokenType.LT);
                this.token.setImage('<');
                return this.token;
            }
            case 62: {
                this.reader.readChar();
                this.token.setType(TokenType.GT);
                this.token.setImage('>');
                return this.token;
            }
            case 42: {
                this.reader.readChar();
                this.token.setType(TokenType.STAR);
                this.token.setImage('*');
                return this.token;
            }
        }
        if (ch == 43 || ch == 45 || RiotChars.range(ch, '0', '9')) {
            this.readNumber();
            if (Checking) {
                this.checkNumber(this.token.getImage(), this.token.getImage2());
            }
            return this.token;
        }
        this.readPrefixedNameOrKeyWord(this.token);
        if (Checking) {
            this.checkKeyword(this.token.getImage());
        }
        return this.token;
    }

    private void readPrefixedNameOrKeyWord(Token token2) {
        long posn = this.reader.getPosition();
        token2.setImage(this.readWord(false));
        token2.setType(TokenType.KEYWORD);
        int ch = this.reader.peekChar();
        if (ch == 58) {
            this.reader.readChar();
            token2.setType(TokenType.PREFIXED_NAME);
            String ln = this.readLocalPart();
            token2.setImage2(ln);
            if (Checking) {
                this.checkPrefixedName(token2.getImage(), token2.getImage2());
            }
        }
        if (posn == this.reader.getPosition()) {
            this.exception(String.format("Unknown char: %c(%d)", ch, ch));
        }
        if (Checking) {
            this.checkKeyword(token2.getImage());
        }
    }

    private String readLongString(int quoteChar, boolean endNL) {
        this.stringBuilder.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == -1) {
                if (endNL) {
                    return this.stringBuilder.toString();
                }
                this.exception("Broken long string");
            }
            if (ch == quoteChar && this.threeQuotes(quoteChar)) {
                return this.stringBuilder.toString();
            }
            if (ch == 92) {
                ch = this.readLiteralEscape();
            }
            this.insertCodepoint(this.stringBuilder, ch);
        }
    }

    private String readLocalPart() {
        return this.readWordSub(true, false);
    }

    private String readWord(boolean leadingDigitAllowed) {
        return this.readWordSub(leadingDigitAllowed, false);
    }

    private String readWordSub(boolean leadingDigitAllowed, boolean leadingSignAllowed) {
        int ch;
        this.stringBuilder.setLength(0);
        int idx = 0;
        if (!leadingDigitAllowed && Character.isDigit(ch = this.reader.peekChar())) {
            return "";
        }
        if (!(leadingSignAllowed || (ch = this.reader.peekChar()) != 45 && ch != 43)) {
            return "";
        }
        while (Character.isLetterOrDigit(ch = this.reader.peekChar()) || ch == 95 || ch == 46 || ch == 45) {
            this.reader.readChar();
            this.stringBuilder.append((char)ch);
            ++idx;
        }
        while (idx > 0 && this.stringBuilder.charAt(idx - 1) == '.') {
            this.reader.pushbackChar(46);
            this.stringBuilder.setLength(idx - 1);
            --idx;
        }
        return this.stringBuilder.toString();
    }

    private boolean threeQuotes(int ch) {
        int ch2 = this.reader.peekChar();
        if (ch2 != ch) {
            return false;
        }
        this.reader.readChar();
        int ch3 = this.reader.peekChar();
        if (ch3 != ch) {
            this.reader.pushbackChar(ch2);
            return false;
        }
        this.reader.readChar();
        return true;
    }

    private void readNumber() {
        boolean isDouble = false;
        boolean isDecimal = false;
        this.stringBuilder.setLength(0);
        int x = 0;
        int ch = this.reader.peekChar();
        if (ch == 48) {
            ++x;
            this.reader.readChar();
            this.stringBuilder.append((char)ch);
            ch = this.reader.peekChar();
            if (ch == 120 || ch == 88) {
                this.reader.readChar();
                this.stringBuilder.append((char)ch);
                TokenizerText.readHex(this.reader, this.stringBuilder);
                this.token.setImage(this.stringBuilder.toString());
                this.token.setType(TokenType.HEX);
                return;
            }
        } else if (ch == 45 || ch == 43) {
            this.readPossibleSign(this.stringBuilder);
        }
        x += this.readDigits(this.stringBuilder);
        ch = this.reader.peekChar();
        if (ch == 46) {
            this.reader.readChar();
            this.stringBuilder.append('.');
            isDecimal = true;
            this.readDigits(this.stringBuilder);
        }
        if (x == 0 && !isDecimal) {
            this.exception("Unrecognized as number");
        }
        if (this.exponent(this.stringBuilder)) {
            isDouble = true;
            isDecimal = false;
        }
        this.token.setImage(this.stringBuilder.toString());
        if (isDouble) {
            this.token.setType(TokenType.DOUBLE);
        } else if (isDecimal) {
            this.token.setType(TokenType.DECIMAL);
        } else {
            this.token.setType(TokenType.INTEGER);
        }
    }

    private static void readHex(PeekReader reader, StringBuilder sb) {
        int ch;
        int x = 0;
        while (RiotChars.range(ch = reader.peekChar(), '0', '9') || RiotChars.range(ch, 'a', 'f') || RiotChars.range(ch, 'A', 'F')) {
            reader.readChar();
            sb.append((char)ch);
            ++x;
        }
        if (x == 0) {
            TokenizerText.exception(reader, "No hex characters after " + sb.toString());
        }
    }

    private boolean exponent(StringBuilder sb) {
        int ch = this.reader.peekChar();
        if (ch != 101 && ch != 69) {
            return false;
        }
        this.reader.readChar();
        sb.append((char)ch);
        this.readPossibleSign(sb);
        int x = this.readDigits(sb);
        if (x == 0) {
            this.exception("Malformed double: " + sb);
        }
        return true;
    }

    private void readPossibleSign(StringBuilder sb) {
        int ch = this.reader.peekChar();
        if (ch == 45 || ch == 43) {
            this.reader.readChar();
            sb.append((char)ch);
        }
    }

    private int readDigits(StringBuilder buffer) {
        int ch;
        int count = 0;
        while (RiotChars.range(ch = this.reader.peekChar(), '0', '9')) {
            this.reader.readChar();
            buffer.append((char)ch);
            ++count;
        }
        return count;
    }

    private String langTag() {
        int ch;
        this.stringBuilder.setLength(0);
        this.a2z(this.stringBuilder);
        if (this.stringBuilder.length() == 0) {
            this.exception("Bad language tag");
        }
        while ((ch = this.reader.peekChar()) == 45) {
            this.reader.readChar();
            this.stringBuilder.append('-');
            int x = this.stringBuilder.length();
            this.a2zN(this.stringBuilder);
            if (this.stringBuilder.length() != x) continue;
            this.exception("Bad language tag");
        }
        return this.stringBuilder.toString();
    }

    private void a2z(StringBuilder sb2) {
        int ch;
        while (RiotChars.isA2Z(ch = this.reader.peekChar())) {
            this.reader.readChar();
            this.stringBuilder.append((char)ch);
        }
    }

    private void a2zN(StringBuilder sb2) {
        int ch;
        while (RiotChars.isA2ZN(ch = this.reader.peekChar())) {
            this.reader.readChar();
            this.stringBuilder.append((char)ch);
        }
    }

    private String readBlankNodeLabel() {
        this.stringBuilder.setLength(0);
        int ch = this.reader.peekChar();
        if (ch == -1) {
            this.exception("Blank node label missing (EOF found)");
        }
        if (RiotChars.isWhitespace(ch)) {
            this.exception("Blank node label missing");
        }
        if (!RiotChars.isAlphaNumeric(ch) && ch != 95) {
            this.exception("Blank node label does not start with alphabetic or _ :" + (char)ch);
        }
        this.reader.readChar();
        this.stringBuilder.append((char)ch);
        while ((ch = this.reader.peekChar()) != -1 && (RiotChars.isAlphaNumeric(ch) || ch == 45 || ch == 95)) {
            this.reader.readChar();
            this.stringBuilder.append((char)ch);
        }
        return this.stringBuilder.toString();
    }

    private String allBetween(int startCh, int endCh, boolean strEscapes, boolean endNL) {
        long y = this.getLine();
        long x = this.getColumn();
        this.stringBuilder.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.reader.readChar()) == -1) {
                if (endNL) {
                    return this.stringBuilder.toString();
                }
                TokenizerText.exception("Broken token: " + this.stringBuilder.toString(), y, x);
            }
            if (ch == 10) {
                TokenizerText.exception("Broken token (newline): " + this.stringBuilder.toString(), y, x);
            }
            if (ch == endCh) {
                return this.stringBuilder.toString();
            }
            if (ch == 92) {
                ch = strEscapes ? this.readLiteralEscape() : this.readUnicodeEscape();
            }
            this.insertCodepoint(this.stringBuilder, ch);
        }
    }

    private void insertCodepoint(StringBuilder buffer, int ch) {
        if (Character.charCount(ch) == 1) {
            buffer.append((char)ch);
        } else {
            if (!Character.isDefined(ch) && !Character.isSupplementaryCodePoint(ch)) {
                this.exception(String.format("Illegal codepoint: 0x%04X", ch));
            }
            char[] chars = Character.toChars(ch);
            buffer.append(chars);
        }
    }

    public long getColumn() {
        return this.reader.getColNum();
    }

    public long getLine() {
        return this.reader.getLineNum();
    }

    private void checkBlankNode(String blankNodeLabel) {
        if (this.checker != null) {
            this.checker.checkBlankNode(blankNodeLabel);
        }
    }

    private void checkLiteralLang(String lexicalForm, String langTag) {
        if (this.checker != null) {
            this.checker.checkLiteralLang(lexicalForm, langTag);
        }
    }

    private void checkLiteralDT(String lexicalForm, Token datatype) {
        if (this.checker != null) {
            this.checker.checkLiteralDT(lexicalForm, datatype);
        }
    }

    private void checkString(String string) {
        if (this.checker != null) {
            this.checker.checkString(string);
        }
    }

    private void checkURI(String uriStr) {
        if (this.checker != null) {
            this.checker.checkURI(uriStr);
        }
    }

    private void checkNumber(String image, String datatype) {
        if (this.checker != null) {
            this.checker.checkNumber(image, datatype);
        }
    }

    private void checkVariable(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkVariable(tokenImage);
        }
    }

    private void checkDirective(int cntrlCode) {
        if (this.checker != null) {
            this.checker.checkDirective(cntrlCode);
        }
    }

    private void checkKeyword(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkKeyword(tokenImage);
        }
    }

    private void checkPrefixedName(String tokenImage, String tokenImage2) {
        if (this.checker != null) {
            this.checker.checkPrefixedName(tokenImage, tokenImage2);
        }
    }

    private void checkControl(int code) {
        if (this.checker != null) {
            this.checker.checkControl(code);
        }
    }

    private final int readLiteralEscape() {
        int c = this.reader.readChar();
        if (c == -1) {
            this.exception("Escape sequence not completed");
        }
        switch (c) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 34: {
                return 34;
            }
            case 39: {
                return 39;
            }
            case 92: {
                return 92;
            }
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.exception(String.format("illegal escape sequence value: %c (0x%02X)", c, c));
        return 0;
    }

    private final int readUnicodeEscape() {
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.exception("Broken escape sequence");
        }
        switch (ch) {
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.exception(String.format("illegal escape sequence value: %c (0x%02X)", ch, ch));
        return 0;
    }

    private final int readUnicode4Escape() {
        return this.readUnicodeEscape(4);
    }

    private final int readUnicode8Escape() {
        int ch8 = this.readUnicodeEscape(8);
        if (ch8 > 0x10FFFF) {
            this.exception(String.format("illegal code point in \\U sequence value: 0x%08X", ch8));
        }
        return ch8;
    }

    private final int readUnicodeEscape(int N) {
        int x = 0;
        for (int i = 0; i < N; ++i) {
            int d = this.readHexChar();
            if (d < 0) {
                return -1;
            }
            x = (x << 4) + d;
        }
        return x;
    }

    private final int readHexChar() {
        int x;
        int ch = this.reader.readChar();
        if (ch == -1) {
            this.exception("Not a hexadecimal character (end of file)");
        }
        if ((x = RiotChars.valHexChar(ch)) != -1) {
            return x;
        }
        this.exception("Not a hexadecimal character: " + (char)ch);
        return -1;
    }

    private boolean expect(String str2) {
        for (int i = 0; i < str2.length(); ++i) {
            char want = str2.charAt(i);
            if (this.reader.eof()) {
                this.exception("End of input during expected string: " + str2);
                return false;
            }
            int inChar = this.reader.readChar();
            if (inChar == want) continue;
            this.exception("expected \"" + str2 + "\"");
            return false;
        }
        return true;
    }

    private void exception(String message) {
        TokenizerText.exception(message, this.reader.getLineNum(), this.reader.getColNum());
    }

    private static void exception(PeekReader reader, String message) {
        TokenizerText.exception(message, reader.getLineNum(), reader.getColNum());
    }

    private static void exception(String message, long line, long col) {
        throw new RiotParseException(message, line, col);
    }
}

