/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.RDFWriterF;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.NoWriterForLangException;
import java.util.Properties;

public class RDFWriterFImpl
implements RDFWriterF {
    protected static Properties langToClassName = null;
    protected static final String[] LANGS = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N-TRIPLES", "N-Triples", "N3", "N3-PP", "N3-PLAIN", "N3-TRIPLES", "N3-TRIPLE", "TURTLE", "Turtle", "TTL"};
    protected static final String[] DEFAULTWRITERS = new String[]{"com.hp.hpl.jena.xmloutput.impl.Basic", "com.hp.hpl.jena.xmloutput.impl.Abbreviated", "com.hp.hpl.jena.rdf.model.impl.NTripleWriter", "com.hp.hpl.jena.rdf.model.impl.NTripleWriter", "com.hp.hpl.jena.rdf.model.impl.NTripleWriter", "com.hp.hpl.jena.n3.N3JenaWriter", "com.hp.hpl.jena.n3.N3JenaWriterPP", "com.hp.hpl.jena.n3.N3TurtleJenaWriter", "com.hp.hpl.jena.n3.N3TurtleJenaWriter", "com.hp.hpl.jena.n3.N3JenaWriterTriples", "com.hp.hpl.jena.n3.N3TurtleJenaWriter", "com.hp.hpl.jena.n3.N3TurtleJenaWriter", "com.hp.hpl.jena.n3.N3TurtleJenaWriter"};
    protected static final String DEFAULTLANG = LANGS[0];
    protected static final String PROPNAMEBASE = "com.hp.hpl.jena.writer.";

    @Override
    public RDFWriter getWriter() {
        return this.getWriter(DEFAULTLANG);
    }

    @Override
    public RDFWriter getWriter(String lang) {
        String className;
        if (lang == null || lang.equals("")) {
            lang = LANGS[0];
        }
        if ((className = langToClassName.getProperty(lang)) == null || className.equals("")) {
            throw new NoWriterForLangException(lang);
        }
        try {
            return (RDFWriter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            if (e instanceof JenaException) {
                throw (JenaException)e;
            }
            throw new JenaException(e);
        }
    }

    @Override
    public String setWriterClassName(String lang, String className) {
        return RDFWriterFImpl.setBaseWriterClassName(lang, className);
    }

    public static String setBaseWriterClassName(String lang, String className) {
        String oldClassName = langToClassName.getProperty(lang);
        langToClassName.setProperty(lang, className);
        return oldClassName;
    }

    static {
        langToClassName = new Properties();
        for (int i = 0; i < LANGS.length; ++i) {
            langToClassName.setProperty(LANGS[i], JenaRuntime.getSystemProperty(PROPNAMEBASE + LANGS[i], DEFAULTWRITERS[i]));
        }
    }
}

