/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.LocationMapper;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.LocatorClassLoader;
import com.hp.hpl.jena.util.LocatorFile;
import com.hp.hpl.jena.util.LocatorURL;
import com.hp.hpl.jena.util.LocatorZip;
import com.hp.hpl.jena.util.TypedStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager {
    public static final String PATH_DELIMITER = ";";
    public static final String filePathSeparator = File.separator;
    private static Logger log = LoggerFactory.getLogger(FileManager.class);
    static FileManager instance = null;
    static boolean logAllLookups = true;
    List<Locator> handlers = new ArrayList<Locator>();
    LocationMapper mapper = null;
    boolean cacheModelLoads = false;
    Map<String, Model> modelCache = null;

    public static FileManager get() {
        if (instance == null) {
            instance = FileManager.makeGlobal();
        }
        return instance;
    }

    public static void setGlobalFileManager(FileManager globalFileManager) {
        instance = globalFileManager;
    }

    public FileManager() {
    }

    public FileManager(FileManager filemanager) {
        this.handlers.addAll(filemanager.handlers);
        this.mapper = null;
        if (filemanager.getLocationMapper() != null) {
            this.mapper = new LocationMapper(filemanager.getLocationMapper());
        }
        this.cacheModelLoads = false;
        this.modelCache = null;
    }

    public static FileManager makeGlobal() {
        FileManager fMgr = new FileManager(LocationMapper.get());
        FileManager.setStdLocators(fMgr);
        return fMgr;
    }

    public static void setStdLocators(FileManager fMgr) {
        fMgr.handlers.clear();
        fMgr.addLocatorFile();
        fMgr.addLocatorURL();
        fMgr.addLocatorClassLoader(fMgr.getClass().getClassLoader());
    }

    public FileManager(LocationMapper _mapper) {
        this.setLocationMapper(_mapper);
    }

    @Deprecated
    public void setMapper(LocationMapper _mapper) {
        this.setLocationMapper(_mapper);
    }

    public void setLocationMapper(LocationMapper _mapper) {
        this.mapper = _mapper;
    }

    public LocationMapper getLocationMapper() {
        return this.mapper;
    }

    public Iterator<Locator> locators() {
        return this.handlers.listIterator();
    }

    public void addLocator(Locator loc) {
        log.debug("Add location: " + loc.getName());
        this.handlers.add(loc);
    }

    public void addLocatorFile() {
        this.addLocatorFile(null);
    }

    public void addLocatorFile(String dir) {
        LocatorFile fLoc = new LocatorFile(dir);
        this.addLocator(fLoc);
    }

    public void addLocatorClassLoader(ClassLoader cLoad) {
        LocatorClassLoader cLoc = new LocatorClassLoader(cLoad);
        this.addLocator(cLoc);
    }

    public void addLocatorURL() {
        LocatorURL loc = new LocatorURL();
        this.addLocator(loc);
    }

    public void addLocatorZip(String zfn) {
        LocatorZip loc = new LocatorZip(zfn);
        this.addLocator(loc);
    }

    public void remove(Locator loc) {
        this.handlers.remove(loc);
    }

    public void resetCache() {
        if (this.modelCache != null) {
            this.modelCache.clear();
        }
    }

    public void setModelCaching(boolean state) {
        this.cacheModelLoads = state;
        if (this.cacheModelLoads && this.modelCache == null) {
            this.modelCache = new HashMap<String, Model>();
        }
    }

    @Deprecated
    public boolean getCachingModels() {
        return this.isCachingModels();
    }

    public boolean isCachingModels() {
        return this.cacheModelLoads;
    }

    public Model getFromCache(String filenameOrURI) {
        if (!this.getCachingModels()) {
            return null;
        }
        return this.modelCache.get(filenameOrURI);
    }

    public boolean hasCachedModel(String filenameOrURI) {
        if (!this.getCachingModels()) {
            return false;
        }
        return this.modelCache.containsKey(filenameOrURI);
    }

    public void addCacheModel(String uri, Model m) {
        if (this.getCachingModels()) {
            this.modelCache.put(uri, m);
        }
    }

    public void removeCacheModel(String uri) {
        if (this.getCachingModels()) {
            this.modelCache.remove(uri);
        }
    }

    public Model loadModel(String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ")");
        }
        return this.loadModelWorker(filenameOrURI, null, null);
    }

    public Model loadModel(String filenameOrURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ", " + rdfSyntax + ")");
        }
        return this.loadModelWorker(filenameOrURI, null, rdfSyntax);
    }

    public Model loadModel(String filenameOrURI, String baseURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ", " + baseURI + ", " + rdfSyntax + ")");
        }
        return this.loadModelWorker(filenameOrURI, baseURI, rdfSyntax);
    }

    private Model loadModelWorker(String filenameOrURI, String baseURI, String rdfSyntax) {
        if (this.hasCachedModel(filenameOrURI)) {
            if (log.isDebugEnabled()) {
                log.debug("Model cache hit: " + filenameOrURI);
            }
            return this.getFromCache(filenameOrURI);
        }
        Model m = ModelFactory.createDefaultModel();
        this.readModelWorker(m, filenameOrURI, baseURI, rdfSyntax);
        if (this.isCachingModels()) {
            this.addCacheModel(filenameOrURI, m);
        }
        return m;
    }

    public Model readModel(Model model, String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ")");
        }
        return this.readModel(model, filenameOrURI, null);
    }

    public Model readModel(Model model, String filenameOrURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ", " + rdfSyntax + ")");
        }
        return this.readModelWorker(model, filenameOrURI, null, rdfSyntax);
    }

    public Model readModel(Model model, String filenameOrURI, String baseURI, String syntax) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ", " + baseURI + ", " + syntax + ")");
        }
        return this.readModelWorker(model, filenameOrURI, baseURI, syntax);
    }

    protected Model readModelWorker(Model model, String filenameOrURI, String baseURI, String syntax) {
        TypedStream in;
        String mappedURI = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !mappedURI.equals(filenameOrURI)) {
            log.debug("Map: " + filenameOrURI + " => " + mappedURI);
        }
        if (syntax == null && baseURI == null && mappedURI.startsWith("http:")) {
            syntax = FileUtils.guessLang(mappedURI);
            model.read(mappedURI, syntax);
            return model;
        }
        if (syntax == null) {
            syntax = FileUtils.guessLang(mappedURI);
            if (syntax == null || syntax.equals("")) {
                syntax = "RDF/XML";
            }
            if (log.isDebugEnabled()) {
                log.debug("Syntax guess: " + syntax);
            }
        }
        if (baseURI == null) {
            baseURI = FileManager.chooseBaseURI(filenameOrURI);
        }
        if ((in = this.openNoMapOrNull(mappedURI)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to locate '" + mappedURI + "'");
            }
            throw new NotFoundException("Not found: " + filenameOrURI);
        }
        if (in.getMimeType() != null) {
            // empty if block
        }
        model.read(in.getInput(), baseURI, syntax);
        try {
            in.getInput().close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return model;
    }

    private static String chooseBaseURI(String baseURI) {
        String scheme = FileUtils.getScheme(baseURI);
        if (scheme != null) {
            if (scheme.equals("file") && !baseURI.startsWith("file:///")) {
                try {
                    String tmp = baseURI.substring("file:".length());
                    File f = new File(tmp);
                    baseURI = "file:///" + f.getCanonicalPath();
                    baseURI = baseURI.replace('\\', '/');
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return baseURI;
        }
        if (baseURI.startsWith("/")) {
            return "file://" + baseURI;
        }
        return "file:" + baseURI;
    }

    public InputStream open(String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("open(" + filenameOrURI + ")");
        }
        String uri = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !uri.equals(filenameOrURI)) {
            log.debug("open: mapped to " + uri);
        }
        return this.openNoMap(uri);
    }

    @Deprecated
    public String remap(String filenameOrURI) {
        return this.mapURI(filenameOrURI);
    }

    public String mapURI(String filenameOrURI) {
        if (this.mapper == null) {
            return filenameOrURI;
        }
        String uri = this.mapper.altMapping(filenameOrURI, null);
        if (uri == null) {
            if (logAllLookups && log.isDebugEnabled()) {
                log.debug("Not mapped: " + filenameOrURI);
            }
            uri = filenameOrURI;
        } else if (log.isDebugEnabled()) {
            log.debug("Mapped: " + filenameOrURI + " => " + uri);
        }
        return uri;
    }

    public String readWholeFileAsUTF8(InputStream in) {
        try {
            int l;
            BufferedReader r = FileUtils.asBufferedUTF8(in);
            StringWriter sw = new StringWriter(1024);
            char[] buff = new char[1024];
            while ((l = r.read(buff)) > 0) {
                sw.write(buff, 0, l);
            }
            ((Reader)r).close();
            sw.close();
            return sw.toString();
        }
        catch (IOException ex) {
            throw new WrappedIOException(ex);
        }
    }

    public String readWholeFileAsUTF8(String filename) {
        InputStream in = this.open(filename);
        if (in == null) {
            throw new NotFoundException("File not found: " + filename);
        }
        return this.readWholeFileAsUTF8(in);
    }

    public InputStream openNoMap(String filenameOrURI) {
        TypedStream in = this.openNoMapOrNull(filenameOrURI);
        if (in == null) {
            return null;
        }
        return in.getInput();
    }

    public TypedStream openNoMapOrNull(String filenameOrURI) {
        for (Locator loc : this.handlers) {
            TypedStream in = loc.open(filenameOrURI);
            if (in == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found: " + filenameOrURI + " (" + loc.getName() + ")");
            }
            return in;
        }
        return null;
    }
}

