% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRepast.R
\name{BuildParameterSet}
\alias{BuildParameterSet}
\title{Builds the simulation parameter set}
\usage{
BuildParameterSet(design, parameters)
}
\arguments{
\item{design}{The experimental desing matrix for at least one factor}

\item{parameters}{All parameters of the repast model.}
}
\value{
A data frame holding all parameters required for running the model
}
\description{
Merges the design matrix with parameters which 
will be keep fixed along simulation runs.
}
\examples{
\dontrun{
   modeldir<- "c:/usr/models/BactoSim(HaldaneEngine-1.0)"
   e<- Model(modeldir=modeldir,dataset="ds::Output")
   Load(e)
   
   f<- AddFactor(name="cyclePoint",min=40,max=90)
   
   p<- GetSimulationParameters(e)
   
   d<- LatinHypercube(factors=f)
   
   p1<- BuildParameterSet(d,p)}

}

