% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim.recomb}
\alias{sim.recomb}
\title{Simulate inheritance on a given pedigree.}
\usage{
sim.recomb(pedinfo, seglength)
}
\arguments{
\item{pedinfo}{dataframe.}

\item{seglength}{positive real number.}
}
\value{
A list of matrices for each meiosis. Each matrix has two columns: founder genome labels (fgl) and recombination breakpoints (recomb). Grandpaternal meiosis precedes grandmaternal meiosis.
}
\description{
\code{sim.recomb} returns inheritance information simulated on a given pedigree over the specified segment length.
}
\details{
\code{pedinfo} must contain at least the following components: unique individual ID named \code{member}, father and mother ID named \code{father} and \code{mother}, and sex (1 for male, 2 for female) named \code{sex}. Parents must precede offsprings. Pedigree founders are treated as unrelated.

\code{seglength} represents length of genomic segment in Haldane centiMorgan. Recombination breakpoints are simulated under a homogeneous Poisson process with rate \code{seglength}/100.
}
\examples{
# a simple pedigree with sibling marriage
pedigree = as.character(rep(1, 5))
member = as.character(c(11, 12, 21, 22, 31))
sex = as.numeric(c(1, 2, 1, 2, 1))
father = as.character(c(NA, NA, 11, 11, 21))
mother = as.character(c(NA, NA, 12, 12, 22))
pedinfo = data.frame(pedigree, member, sex, father, mother, stringsAsFactors = FALSE)

# simulate inheritance over a segment of 100 centiMorgan
sim.recomb(pedinfo, 100)
}
