% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrr.R
\name{rrr.fit}
\alias{rrr.fit}
\title{Fitting reduced-rank regression with a specific rank}
\usage{
rrr.fit(Y, X, nrank = 1, weight = NULL, coefSVD = FALSE)
}
\arguments{
\item{Y}{a matrix of response (n by q)}

\item{X}{a matrix of covariate (n by p)}

\item{nrank}{an integer specifying the desired rank}

\item{weight}{a square matrix of weight (q by q); The default is the
identity matrix}

\item{coefSVD}{logical indicating the need for SVD for the coeffient matrix
in the output; used in ssvd estimation}
}
\value{
S3 \code{rrr} object, a list consisting of \item{coef}{coefficient
    of rrr} \item{coef.ls}{coefficient of least square} \item{fitted}{fitted
    value of rrr} \item{fitted.ls}{fitted value of least square}
    \item{A}{right singular matrix} \item{Ad}{a vector of sigular values}
    \item{rank}{rank of the fitted rrr}
}
\description{
Given a response matrix and a covariate matrix, this function fits reduced
rank regression for a specified rank. It reduces to singular value
decomposition if the covariate matrix is the identity matrix.
}
\examples{
Y <- matrix(rnorm(400), 100, 4)
X <- matrix(rnorm(800), 100, 8)
rfit <- rrr.fit(Y, X, nrank = 2)
coef(rfit)
}
