% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r4.R
\name{r4}
\alias{r4}
\title{Robust reduced-rank regression}
\usage{
r4(Y, X, maxrank = min(dim(Y), dim(X)),
   method = c("rowl0", "rowl1", "entrywise"),
   Gamma = NULL, ic.type = c("AIC", "BIC", "PIC"),
   modstr = list(), control = list())
}
\arguments{
\item{Y}{a matrix of response (n by q)}

\item{X}{a matrix of covariate (n by p)}

\item{maxrank}{maximum rank for fitting}

\item{method}{outlier detection method, either entrywise or rowwise}

\item{Gamma}{weighting matrix in the loss function}

\item{ic.type}{information criterion, AIC, BIC or PIC}

\item{modstr}{a list of model parameters controlling the model
fitting}

\item{control}{a list of parameters for controlling the fitting process}
}
\value{
a list consisting of
  \item{coef.path}{solutuon path of regression coefficients}
  \item{s.path}{solutuon path of sparse mean shifts}
  \item{s.norm.path}{solutuon path of the norms of sparse mean shifts}
  \item{ic.path}{paths of information criteria}
  \item{ic.smooth.path}{smoothed paths of information criteria}
  \item{lambda.path}{paths of the tuning parameter}
  \item{id.solution}{ids of the selected solutions on the path}
  \item{ic.best}{lowest values of the information criteria}
  \item{rank.best}{rank values of selected solutions}
  \item{coef}{estimated regression coefficients}
  \item{s}{estimated sparse mean shifts}
  \item{rank}{rank estimate}
}
\description{
Perform robust reduced-rank regression.
}
\details{
The model parameters can be controlled through argument \code{modstr}.
The available elements include
\itemize{
    \item{nlam}: parameter in the augmented Lagrangian function.
    \item{adaptive}: if TRUE, use leverage values for adaptive
        penalization.
    \item{weights}: user supplied weights for adaptive penalization.
    \item{minlam}: maximum proportion of outliers.
    \item{maxlam}: maximum proportion of good observations.
    \item{delid}: discarded observation indices for initial estimation.
}
The model fitting can be controlled through argument \code{control}.
The available elements include
\itemize{
    \item{epsilon}: convergence tolerance.
    \item{maxit}: maximum number of iterations.
    \item{qr.tol}: tolerance for qr decomposition.
    \item{tol}: tolerance.
}
}
\examples{
\dontrun{
library(rrpack)
n <- 100; p <- 500; q <- 50
xrank <- 10; nrank <- 3; rmax <- min(n, p, q, xrank)
nlam <- 100; gamma <- 2
rho_E <- 0.3
rho_X <- 0.5
nlev <- 0
vlev <- 0
vout <- NULL
vlevsd <- NULL
nout <- 0.1 * n
s2n <- 1
voutsd <- 2
simdata <- rrr.sim5(n, p, q, nrank, rx = xrank, s2n = s2n,
                    rho_X = rho_X, rho_E = rho_E, nout = nout, vout = vout,
                    voutsd = voutsd,nlev = nlev,vlev=vlev,vlevsd=vlevsd)
Y <- simdata$Y
X <- simdata$X
fit <- r4(Y, X, maxrank = rmax,
               method = "rowl0", ic.type= "PIC")
summary(fit)
coef(fit)
which(apply(fit$s,1,function(a)sum(a^2))!=0)
}
}
\references{
She, Y. and Chen, K. (2017) Robust reduced-rank regression.
\emph{Biometrika}, 104 (3), 633--647.
}
