% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_2ggplots.R
\name{add_2ggplots}
\alias{add_2ggplots}
\title{Add two ggplots into a document object}
\usage{
add_2ggplots(
  mydoc,
  plot1,
  plot2,
  preprocessing = "",
  width = 3,
  height = 2.5,
  top = 2
)
}
\arguments{
\item{mydoc}{A document object}

\item{plot1}{An R code encoding the first ggplot}

\item{plot2}{An R code encoding the second ggplot}

\item{preprocessing}{preprocessing}

\item{width}{plot width in inches}

\item{height}{plot height in inches}

\item{top}{top plot position in inches}
}
\value{
a document object
}
\description{
Add two ggplots into a document object
}
\examples{
\donttest{
require(ggplot2)
require(magrittr)
require(officer)
require(rvg)
plot1 <- "ggplot(data = iris, aes(Sepal.Length, Petal.Length)) + geom_point()"
plot2 <- "ggplot(data = iris, aes(Sepal.Length, Petal.Length, color = Species)) + geom_point()"
read_pptx() \%>\% add_text(title="Two ggplots") \%>\% add_2ggplots(plot1=plot1,plot2=plot2)
read_docx() \%>\% add_text(title="Two ggplots") \%>\% add_2ggplots(plot1=plot1,plot2=plot2)
}
}
