% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveCloud.R
\name{moveCloud}
\alias{moveCloud}
\title{moveCloud}
\usage{
moveCloud(xy = xy, obs.dates = obs.dates, data.path = NULL,
  buffer.size = NULL, remove.file = FALSE)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{obs.dates}{Object of class \emph{Date} with observation dates of \emph{xy}.}

\item{data.path}{Output data path for downloaded data.}

\item{buffer.size}{Two element vector with temporal buffer size (expressed in days).}

\item{remove.file}{Logical. Should the files be deleted after usage?}
}
\value{
A \emph{list} object reporting on the variability of cloud cover within and around each observation dates.
}
\description{
{Provides historical information on cloud cover for a set of coordinate
pairs. The temporal information is adjusted to the sample observation date}.
}
\details{
{This function uses daily cloud fraction data from NASA's NEO service.
For each observation date in \emph{obs.dates}, the function downloads the correspondent image
and extracts the percent of cloud cover for the corresponding samples in \emph{xy}. If
\emph{data.path} is specified, the function will look within the provided directory for the
cloud cover images. If they exist, they won't be downloaded reducing the amount of time required
by the function. Moreover, if \emph{buffer.size} is specified, for each date, the function will only
consider images that are within the specified temporal buffer. \emph{buffer.size} requires a two
element vector which specifies the buffer size before and after the target dates. These additional
images will be used to report on the closest time step with the lowest possible cloud cover. The
final output provides a \emph{data.frame} ($report) with information on:
\itemize{
 \item{\emph{cloud cover \% (day)}: cloud cover for the observation dates.}
 \item{\emph{best date (after)}: dates before the observation dates with the lowest cloud cover.}
 \item{\emph{best date cloud cover \% (before)}: cloud cover for best before dates.}
 \item{\emph{best date (after)}: dates after the observation dates with the lowest cloud cover.}
 \item{\emph{best date cloud cover \% (after)}: cloud cover best after dates.}}
 Finally, the function generates a plot ($plot) reporting on the variability of cloud cover
 within the dates provided by \emph{obs.dates} and the number of samples registered within them.}
}
\examples{
\dontrun{

 require(raster)

 # read movement data
 data(shortMove)

 # test function for 30 day buffer
 od <- as.Date(shortMove@data$date)
 c.cover <- moveCloud(xy=shortMove, obs.dates=od, data.path=".", buffer.size=c(30,30))

}
}
\references{
\url{https://cneos.jpl.nasa.gov/}
}
\seealso{
\code{\link{sMoveRes}} \code{\link{tMoveRes}}
}
